/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.configuration;

import ch.qos.logback.classic.Level;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.restheart.configuration.Configuration;
import org.restheart.configuration.Utils;

public record Logging(Level logLevel, boolean logToFile, String logFilePath, boolean logToConsole, boolean ansiConsole, List<String> packages, boolean fullStacktrace, int requestsLogMode, List<String> tracingHeaders) {
    public static final String LOGGING_KEY = "logging";
    public static final String LOG_LEVEL_KEY = "log-level";
    public static final String ENABLE_LOG_FILE_KEY = "log-to-file";
    public static final String LOG_FILE_PATH_KEY = "log-file-path";
    public static final String ENABLE_LOG_CONSOLE_KEY = "log-to-console";
    public static final String ANSI_CONSOLE_KEY = "ansi-console";
    public static final String REQUESTS_LOG_MODE = "requests-log-mode";
    public static final String TRACING_HEADERS_KEY = "tracing-headers";
    public static final String PACKAGES_KEY = "packages";
    public static final String PRINT_FULL_STACKTRACE = "full-stacktrace";
    private static final List<String> DEFAULT_PACKAGES = List.of("org.restheart", "com.restheart");
    private static Logging DEFAULT_LOGGING = new Logging(Level.INFO, false, null, true, true, DEFAULT_PACKAGES, false, 1, new ArrayList<String>());

    public Logging(Map<String, Object> conf, boolean silent) {
        this(Logging._level(conf, DEFAULT_LOGGING.logLevel(), silent), Utils.getOrDefault(conf, ENABLE_LOG_FILE_KEY, Boolean.valueOf(DEFAULT_LOGGING.logToFile()), silent), Utils.getOrDefault(conf, LOG_FILE_PATH_KEY, DEFAULT_LOGGING.logFilePath(), silent), Utils.getOrDefault(conf, ENABLE_LOG_CONSOLE_KEY, Boolean.valueOf(DEFAULT_LOGGING.logToConsole()), silent), Utils.getOrDefault(conf, ANSI_CONSOLE_KEY, Boolean.valueOf(DEFAULT_LOGGING.ansiConsole()), silent), Utils.getOrDefault(conf, PACKAGES_KEY, DEFAULT_LOGGING.packages(), true), Utils.getOrDefault(conf, PRINT_FULL_STACKTRACE, Boolean.valueOf(DEFAULT_LOGGING.fullStacktrace()), true), Utils.getOrDefault(conf, REQUESTS_LOG_MODE, Integer.valueOf(DEFAULT_LOGGING.requestsLogMode()), silent), Utils.getOrDefault(conf, TRACING_HEADERS_KEY, DEFAULT_LOGGING.tracingHeaders(), true));
    }

    public static Logging build(Map<String, Object> conf, boolean silent) {
        Map<String, Object> logging = Utils.asMap(conf, LOGGING_KEY, null, silent);
        if (logging != null) {
            return new Logging(logging, silent);
        }
        return DEFAULT_LOGGING;
    }

    private static Level _level(Map<String, Object> conf, Level defaultLevel, boolean silent) {
        String _level = Utils.getOrDefault(conf, LOG_LEVEL_KEY, null, true);
        if (_level == null) {
            Configuration.LOGGER.warn("Parameter \"{}\" not specified in the configuration file, using its default value \"{}\"", (Object)LOG_LEVEL_KEY, (Object)defaultLevel);
            return defaultLevel;
        }
        try {
            return Level.valueOf((String)_level);
        }
        catch (Throwable t) {
            Configuration.LOGGER.warn("Wrong parameter \"{}\"={} specified in the configuration file, using its default value \"{}\"", new Object[]{LOG_LEVEL_KEY, _level, defaultLevel});
            return defaultLevel;
        }
    }
}

