/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.restheart.configuration.Configuration;
import org.restheart.configuration.Utils;

public record ProxiedResource(String name, String location, List<String> proxyPass, boolean rewriteHostHeader, int connectionPerThread, int maxQueueSize, int softMaxConnectionsPerThread, int connectionsTTL, int problemServerRetry) {
    public static final String PROXIED_RESOURCES_KEY = "proxies";
    public static final String PROXY_NAME = "name";
    public static final String PROXY_LOCATION_KEY = "location";
    public static final String PROXY_PASS_KEY = "proxy-pass";
    public static final String PROXY_REWRITE_HOST_HEADER = "rewrite-host-header";
    public static final String PROXY_CONNECTIONS_PER_THREAD = "connections-per-thread";
    public static final String PROXY_MAX_QUEUE_SIZE = "max-queue-size";
    public static final String PROXY_SOFT_MAX_CONNECTIONS_PER_THREAD = "soft-max-connections-per-thread";
    public static final String PROXY_TTL = "connections-ttl";
    public static final String PROXY_PROBLEM_SERVER_RETRY = "problem-server-retry";

    public ProxiedResource(Map<String, Object> conf, boolean silent) {
        this(Utils.getOrDefault(conf, PROXY_NAME, null, silent), Utils.getOrDefault(conf, PROXY_LOCATION_KEY, null, silent), ProxiedResource._proxyPass(conf, silent), Utils.getOrDefault(conf, PROXY_REWRITE_HOST_HEADER, Boolean.valueOf(true), true), Utils.getOrDefault(conf, PROXY_CONNECTIONS_PER_THREAD, Integer.valueOf(10), true), Utils.getOrDefault(conf, PROXY_MAX_QUEUE_SIZE, Integer.valueOf(0), true), Utils.getOrDefault(conf, PROXY_SOFT_MAX_CONNECTIONS_PER_THREAD, Integer.valueOf(5), true), Utils.getOrDefault(conf, PROXY_TTL, Integer.valueOf(-1), true), Utils.getOrDefault(conf, PROXY_PROBLEM_SERVER_RETRY, Integer.valueOf(10), true));
    }

    private static List<String> _proxyPass(Map<String, Object> conf, boolean silent) {
        Object _proxyPass = Utils.getOrDefault(conf, PROXY_PASS_KEY, null, silent);
        if (_proxyPass == null) {
            return new ArrayList<String>();
        }
        if (_proxyPass instanceof String) {
            String s = _proxyPass;
            ArrayList<String> ret = new ArrayList<String>();
            ret.add(s);
            return ret;
        }
        if (_proxyPass instanceof List) {
            List l = _proxyPass;
            l.stream().filter(p -> !(p instanceof String)).forEach(ip -> Configuration.LOGGER.warn("Invalid proxy-pass {} ", ip));
            return l.stream().filter(p -> p instanceof String).map(p -> (String)p).collect(Collectors.toList());
        }
        Configuration.LOGGER.warn("Invalid proxy-pass value {}", _proxyPass);
        return new ArrayList<String>();
    }

    public static List<ProxiedResource> build(Map<String, Object> conf, boolean silent) {
        List<Map<String, Object>> proxies = Utils.asListOfMaps(conf, PROXIED_RESOURCES_KEY, null, silent);
        if (proxies != null) {
            return proxies.stream().map(p -> new ProxiedResource((Map<String, Object>)p, silent)).collect(Collectors.toList());
        }
        return new ArrayList<ProxiedResource>();
    }
}

