/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.restheart.configuration.Utils;

public record StaticResource(String what, String where, String welcomeFile, boolean embedded) {
    public static final String STATIC_RESOURCES_MOUNTS_KEY = "static-resources";
    public static final String STATIC_RESOURCES_MOUNT_WHAT_KEY = "what";
    public static final String STATIC_RESOURCES_MOUNT_WHERE_KEY = "where";
    public static final String STATIC_RESOURCES_MOUNT_WELCOME_FILE_KEY = "welcome-file";
    public static final String STATIC_RESOURCES_MOUNT_EMBEDDED_KEY = "embedded";

    public StaticResource(Map<String, Object> conf, boolean silent) {
        this(Utils.getOrDefault(conf, STATIC_RESOURCES_MOUNT_WHAT_KEY, null, silent), Utils.getOrDefault(conf, STATIC_RESOURCES_MOUNT_WHERE_KEY, null, silent), Utils.getOrDefault(conf, STATIC_RESOURCES_MOUNT_WELCOME_FILE_KEY, "index.html", true), Utils.getOrDefault(conf, STATIC_RESOURCES_MOUNT_EMBEDDED_KEY, Boolean.valueOf(false), true));
    }

    public static List<StaticResource> build(Map<String, Object> conf, boolean silent) {
        List<Map<String, Object>> staticResources = Utils.asListOfMaps(conf, STATIC_RESOURCES_MOUNTS_KEY, null, silent);
        if (staticResources != null) {
            return staticResources.stream().map(p -> new StaticResource((Map<String, Object>)p, silent)).collect(Collectors.toList());
        }
        return new ArrayList<StaticResource>();
    }
}

