/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.configuration;

import java.util.Map;
import org.restheart.configuration.Utils;

public record TLSListener(boolean enabled, String host, int port, String keystorePath, String keystorePwd, String certificatePwd) {
    public static final String HTTPS_LISTENER_KEY = "https-listener";
    public static final String ENABLED_KEY = "enabled";
    public static final String HOST_KEY = "host";
    public static final String PORT_KEY = "port";
    public static final String KEYSTORE_PATH_KEY = "keystore-path";
    public static final String KEYSTOPRE_PWD_KEY = "keystore-password";
    public static final String CERT_PWD_KEY = "certificate-password";

    public TLSListener(Map<String, Object> conf, String listenerKey, TLSListener defaultValue, boolean silent) {
        this(Utils.findOrDefault(conf, "/" + listenerKey + "/enabled", defaultValue.enabled(), silent), Utils.findOrDefault(conf, "/" + listenerKey + "/host", defaultValue.host(), silent), Utils.findOrDefault(conf, "/" + listenerKey + "/port", defaultValue.port(), silent), Utils.findOrDefault(conf, "/" + listenerKey + "/keystore-path", defaultValue.keystorePath(), silent), Utils.findOrDefault(conf, "/" + listenerKey + "/keystore-password", defaultValue.keystorePwd(), silent), Utils.findOrDefault(conf, "/" + listenerKey + "/certificate-password", defaultValue.certificatePwd(), silent));
    }

    @Override
    public String toString() {
        return "{enabled: " + this.enabled + ", host: " + this.host + ", port: " + this.port + ", keystorePath: " + this.keystorePath + ", keystorePwd: " + (this.keystorePwd == null ? "null" : "******") + ", certificatePwd:" + (this.certificatePwd == null ? "null" : "******") + "}";
    }
}

