/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.configuration;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.jxpath.JXPathContext;
import org.bson.Document;
import org.restheart.configuration.Configuration;
import org.restheart.configuration.RhOverrideRegion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.Option;

public class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Configuration.class);
    private static final Set<Option> UNDERTOW_OPTIONS = Sets.newHashSet();
    private static final Set<Option<Long>> LONG_UNDERTOW_OPTIONS;
    private static Pattern SPLIT_REGEX;

    public static <V> V getOrDefault(Configuration conf, String key, V defaultValue, boolean silent) {
        return Utils.getOrDefault(conf.toMap(), key, defaultValue, silent);
    }

    public static <V> V getOrDefault(Map<String, Object> conf, String key, V defaultValue, boolean silent) {
        if (conf == null || conf.get(key) == null) {
            if (defaultValue != null && !silent) {
                LOGGER.warn("Parameter \"{}\" not specified in the configuration file, using its default value \"{}\"", (Object)key, defaultValue);
            }
            return defaultValue;
        }
        try {
            if (!silent) {
                LOGGER.trace("configuration paramenter \"{}\" set to \"{}\"", (Object)key, conf.get(key));
            }
            return (V)conf.get(key);
        }
        catch (Throwable t) {
            if (!silent) {
                LOGGER.warn("Wrong configuration parameter \"{}\": \"{}\", using its default value \"{}\"", new Object[]{key, conf.get(key), defaultValue});
            }
            return defaultValue;
        }
    }

    public static <V> V find(Map<String, Object> conf, String xpath, boolean silent) {
        return Utils.findOrDefault(conf, xpath, null, silent);
    }

    public static <V> V findOrDefault(Map<String, Object> conf, String xpath, V defaultValue, boolean silent) {
        JXPathContext ctx = JXPathContext.newContext(conf);
        ctx.setLenient(true);
        try {
            Object value = ctx.getValue(xpath);
            if (value == null) {
                if (defaultValue != null && !silent) {
                    LOGGER.warn("Parameter \"{}\" not specified in the configuration file, using its default value \"{}\"", (Object)xpath, defaultValue);
                }
                return defaultValue;
            }
            if (!silent) {
                LOGGER.trace("configuration paramenter \"{}\" set to \"{}\"", (Object)xpath, value);
            }
            return (V)value;
        }
        catch (Throwable t) {
            if (!silent) {
                LOGGER.warn("Wrong configuration parameter \"{}\": \"{}\", using its default value \"{}\"", (Object)xpath, defaultValue);
            }
            return defaultValue;
        }
    }

    public static List<Map<String, Object>> asListOfMaps(Map<String, Object> conf, String key, List<Map<String, Object>> defaultValue, boolean silent) {
        if (conf == null) {
            if (!silent) {
                LOGGER.trace("parameter {} not specified in the configuration file, using its default value {}", (Object)key, defaultValue);
            }
            return defaultValue;
        }
        Object o = conf.get(key);
        if (o == null) {
            if (!silent) {
                LOGGER.trace("configuration parameter {} not specified in the configuration file, using its default value {}", (Object)key, defaultValue);
            }
            return defaultValue;
        }
        if (o instanceof List) {
            try {
                return (List)o;
            }
            catch (Throwable t) {
                LOGGER.warn("wrong configuration parameter {}", (Object)key);
                return defaultValue;
            }
        }
        if (!silent) {
            LOGGER.warn("wrong configuration parameter {}, expecting an array of objects", (Object)key, defaultValue);
        }
        return defaultValue;
    }

    public static Map<String, Map<String, Object>> asMapOfMaps(Map<String, Object> conf, String key, Map<String, Map<String, Object>> defaultValue, boolean silent) {
        if (conf == null) {
            if (!silent) {
                LOGGER.trace("parameter {} not specified in the configuration file, using its default value {}", (Object)key, defaultValue);
            }
            return defaultValue;
        }
        Object o = conf.get(key);
        if (o == null) {
            if (!silent) {
                LOGGER.trace("configuration parameter {} not specified in the configuration file, using its default value {}", (Object)key, defaultValue);
            }
            return defaultValue;
        }
        if (o instanceof Map) {
            try {
                return (Map)o;
            }
            catch (Throwable t) {
                if (!silent) {
                    LOGGER.warn("wrong configuration parameter {}, expecting a map of maps, using its default value {}", (Object)key, defaultValue);
                }
                return defaultValue;
            }
        }
        if (!silent) {
            LOGGER.warn("wrong configuration parameter {}, expecting a map of maps, using its default value {}", (Object)key, defaultValue);
        }
        return defaultValue;
    }

    public static Map<String, Object> asMap(Map<String, Object> conf, String key, Map<String, Object> defaultValue, boolean silent) {
        if (conf == null) {
            if (!silent) {
                LOGGER.trace("parameter {} not specified in the configuration file, using its default value {}", (Object)key, defaultValue);
            }
            return null;
        }
        Object o = conf.get(key);
        if (o == null) {
            if (!silent) {
                LOGGER.trace("configuration parameter {} not specified in the configuration file, using its default value {}", (Object)key, defaultValue);
            }
            return defaultValue;
        }
        if (o instanceof Map) {
            Map m = (Map)o;
            try {
                return (Map)o;
            }
            catch (Throwable t) {
                if (!silent) {
                    LOGGER.warn("wrong configuration parameter {}, expecting a map, using its default value {}", (Object)key, defaultValue);
                }
                return null;
            }
        }
        if (!silent) {
            LOGGER.warn("wrong configuration parameter {}, expecting a map, using its default value {}", (Object)key, defaultValue);
        }
        return null;
    }

    public static int[] asArrayOfInts(Map<String, Object> conf, String key, int[] defaultValue, boolean silent) {
        if (conf == null) {
            if (!silent) {
                LOGGER.trace("parameter {} not specified in the configuration file, using its default value {}", (Object)key, null);
            }
            return null;
        }
        Object o = conf.get(key);
        if (o instanceof List) {
            List l = (List)o;
            try {
                return l.stream().filter(i -> i instanceof Integer).mapToInt(i -> (Integer)i).toArray();
            }
            catch (Throwable t) {
                if (!silent) {
                    LOGGER.warn("wrong configuration parameter {}, expecting a list of ints", (Object)key);
                }
                return null;
            }
        }
        if (!silent) {
            LOGGER.warn("wrong configuration parameter {}, expecting a list of ints", (Object)key);
        }
        return null;
    }

    public static List<String> asListOfStrings(Map<String, Object> conf, String key, List<String> defaultValue, boolean silent) {
        if (conf == null || conf.get(key) == null) {
            if (defaultValue != null && !silent) {
                LOGGER.trace("parameter {} not specified in the configuration file, using its default value {}", (Object)key, defaultValue);
            }
            return defaultValue;
        }
        if (conf.get(key) instanceof List) {
            if (!silent) {
                LOGGER.debug("paramenter {} set to {}", (Object)key, conf.get(key));
            }
            try {
                List ret = (List)conf.get(key);
                if (ret.isEmpty()) {
                    if (!silent) {
                        LOGGER.warn("wrong value for parameter {}: {}, using its default value {}", new Object[]{key, conf.get(key), defaultValue});
                    }
                    return defaultValue;
                }
                return ret;
            }
            catch (Throwable t) {
                if (!silent) {
                    LOGGER.warn("wrong value for parameter {}: {}, using its default value {}", new Object[]{key, conf.get(key), defaultValue});
                }
                return defaultValue;
            }
        }
        if (!silent) {
            LOGGER.warn("wrong value for parameter {}: {}, using its default value {}", new Object[]{key, conf.get(key), defaultValue});
        }
        return defaultValue;
    }

    public static Boolean asBoolean(Map<String, Object> conf, String key, Boolean defaultValue, boolean silent) {
        return Utils.getOrDefault(conf, key, defaultValue, silent);
    }

    public static String asString(Map<String, Object> conf, String key, String defaultValue, boolean silent) {
        return Utils.getOrDefault(conf, key, defaultValue, silent);
    }

    public static Integer asInteger(Map<String, Object> conf, String key, Integer defaultValue, boolean silent) {
        return Utils.getOrDefault(conf, key, defaultValue, silent);
    }

    public static Long asLong(Map<String, Object> conf, String key, Long defaultValue, boolean silent) {
        if (conf == null || conf.get(key) == null) {
            if (defaultValue != null && !silent) {
                LOGGER.debug("parameter {} not specified in the configuration file, using its default value {}", (Object)key, (Object)defaultValue);
            }
            return defaultValue;
        }
        if (conf.get(key) instanceof Number) {
            if (!silent) {
                LOGGER.debug("paramenter {} set to {}", (Object)key, conf.get(key));
            }
            try {
                return Long.parseLong(conf.get(key).toString());
            }
            catch (NumberFormatException nfe) {
                if (!silent) {
                    LOGGER.warn("wrong value for parameter {}: {}, using its default value {}", new Object[]{key, conf.get(key), defaultValue});
                }
                return defaultValue;
            }
        }
        if (!silent) {
            LOGGER.warn("wrong value for parameter {}: {}, using its default value {}", new Object[]{key, conf.get(key), defaultValue});
        }
        return defaultValue;
    }

    public static String valueFromEnv(String confParameter) {
        return Utils.valueFromEnv(confParameter, false);
    }

    public static String valueFromEnv(String confParameter, boolean silent) {
        String value = Utils._valueFromEnv("RH", confParameter, silent);
        if (value != null) {
            return value;
        }
        return null;
    }

    private static String _valueFromEnv(String prefix, String confParameter, boolean silent) {
        String key = prefix != null ? prefix + "_" + confParameter.toUpperCase().replaceAll("-", "_") : confParameter.toUpperCase().replaceAll("-", "_");
        return Utils.__valueFromEnv(confParameter, key, silent);
    }

    private static String __valueFromEnv(String confParameter, String key, boolean silent) {
        String envValue = System.getProperty(key);
        if (envValue == null) {
            envValue = System.getenv(key);
        }
        if (!silent && envValue != null) {
            LOGGER.warn(">>> Found environment variable '{}': overriding parameter '{}' with value '{}'", new Object[]{key, confParameter, envValue});
        }
        return envValue;
    }

    public static void setConnectionOptions(Undertow.Builder builder, Configuration configuration) {
        Map<String, Object> options = configuration.getConnectionOptions();
        UNDERTOW_OPTIONS.stream().forEach(option -> {
            Object value;
            if (options.containsKey(option.getName()) && (value = options.get(option.getName())) != null) {
                builder.setServerOption(option, value);
                LOGGER.trace("Connection option {}={}", (Object)option.getName(), value);
            }
        });
        LONG_UNDERTOW_OPTIONS.stream().forEach(option -> {
            Object value;
            if (options.containsKey(option.getName()) && (value = options.get(option.getName())) != null) {
                Long lvalue = 0L + (long)((Integer)value).intValue();
                builder.setServerOption(option, (Object)lvalue);
                LOGGER.trace("Connection option {}={}", (Object)option.getName(), (Object)lvalue);
            }
        });
    }

    private static List<String> splitOverrides(String rho) {
        Matcher m = SPLIT_REGEX.matcher(rho);
        ArrayList<RhOverrideRegion> regions = new ArrayList<RhOverrideRegion>();
        int lastMatch = 0;
        while (m.find()) {
            if (m.group().length() != 1) continue;
            regions.add(new RhOverrideRegion(lastMatch, m.start()));
            lastMatch = m.end();
        }
        if (lastMatch < rho.length()) {
            regions.add(new RhOverrideRegion(lastMatch, rho.length()));
        }
        ArrayList<String> assignments = new ArrayList<String>();
        regions.stream().forEach(region -> {
            String assignment = rho.substring(region.start(), region.end()).strip();
            if (!assignment.isBlank()) {
                assignments.add(assignment);
            }
        });
        return assignments;
    }

    public static List<RhOverride> overrides(String rho) {
        return Utils.overrides(rho, false, false);
    }

    public static List<RhOverride> overrides(String rho, boolean lenient, boolean silent) {
        ArrayList<RhOverride> overrides = new ArrayList<RhOverride>();
        List<String> assignments = Utils.splitOverrides(rho);
        assignments.stream().forEach(assignment -> {
            block13: {
                int operator = assignment.indexOf("->");
                if (operator == -1) {
                    if (!lenient) {
                        throw new IllegalArgumentException("invalid override: " + assignment);
                    }
                    if (!silent) {
                        LOGGER.warn("invalid override: {}", assignment);
                    }
                } else {
                    String path;
                    block12: {
                        path = assignment.substring(0, operator).strip();
                        if (!path.startsWith("/") && !lenient) {
                            throw new IllegalArgumentException("invalid override, path must be absolute, i.e. starting with /: " + assignment);
                        }
                        JXPathContext ctx = JXPathContext.newContext((Object)Maps.newHashMap());
                        ctx.setLenient(true);
                        try {
                            ctx.getPointer(path);
                        }
                        catch (Exception e) {
                            if (!lenient) {
                                throw new IllegalArgumentException("invalid override, invalid path: " + assignment + ", " + e.getMessage());
                            }
                            if (silent) break block12;
                            LOGGER.warn("invalid override, invalid path: {}, {}", assignment, (Object)e.getMessage());
                        }
                    }
                    String _value = assignment.substring(operator + 2, assignment.length()).strip();
                    String e = "{\"e\":".concat(_value).concat("}");
                    try {
                        Object value = Document.parse((String)e).get((Object)"e");
                        if (value instanceof Document) {
                            Document dv = (Document)value;
                            value = dv.entrySet().stream().collect(HashMap::new, (m, v) -> m.put(v.getKey(), v.getValue()), HashMap::putAll);
                        }
                        overrides.add(new RhOverride(path, value, (String)assignment));
                    }
                    catch (Exception ex) {
                        if (!lenient) {
                            throw new IllegalArgumentException("invalid override, value is not valid json: " + assignment);
                        }
                        if (silent) break block13;
                        LOGGER.warn("invalid override, value is not valid json: {}", assignment);
                    }
                }
            }
        });
        return overrides;
    }

    static {
        UNDERTOW_OPTIONS.add(UndertowOptions.ALLOW_EQUALS_IN_COOKIE_VALUE);
        UNDERTOW_OPTIONS.add(UndertowOptions.ALLOW_UNKNOWN_PROTOCOLS);
        UNDERTOW_OPTIONS.add(UndertowOptions.ALLOW_UNESCAPED_CHARACTERS_IN_URL);
        UNDERTOW_OPTIONS.add(UndertowOptions.ALWAYS_SET_DATE);
        UNDERTOW_OPTIONS.add(UndertowOptions.ALWAYS_SET_KEEP_ALIVE);
        UNDERTOW_OPTIONS.add(UndertowOptions.BUFFER_PIPELINED_DATA);
        UNDERTOW_OPTIONS.add(UndertowOptions.DECODE_URL);
        UNDERTOW_OPTIONS.add(UndertowOptions.ENABLE_HTTP2);
        UNDERTOW_OPTIONS.add(UndertowOptions.ENABLE_RFC6265_COOKIE_VALIDATION);
        UNDERTOW_OPTIONS.add(UndertowOptions.ENABLE_STATISTICS);
        UNDERTOW_OPTIONS.add(UndertowOptions.HTTP2_HUFFMAN_CACHE_SIZE);
        UNDERTOW_OPTIONS.add(UndertowOptions.HTTP2_SETTINGS_ENABLE_PUSH);
        UNDERTOW_OPTIONS.add(UndertowOptions.HTTP2_SETTINGS_HEADER_TABLE_SIZE);
        UNDERTOW_OPTIONS.add(UndertowOptions.HTTP2_SETTINGS_INITIAL_WINDOW_SIZE);
        UNDERTOW_OPTIONS.add(UndertowOptions.HTTP2_SETTINGS_MAX_CONCURRENT_STREAMS);
        UNDERTOW_OPTIONS.add(UndertowOptions.HTTP2_SETTINGS_MAX_FRAME_SIZE);
        UNDERTOW_OPTIONS.add(UndertowOptions.IDLE_TIMEOUT);
        UNDERTOW_OPTIONS.add(UndertowOptions.MAX_AJP_PACKET_SIZE);
        UNDERTOW_OPTIONS.add(UndertowOptions.MAX_BUFFERED_REQUEST_SIZE);
        UNDERTOW_OPTIONS.add(UndertowOptions.MAX_CACHED_HEADER_SIZE);
        UNDERTOW_OPTIONS.add(UndertowOptions.MAX_CONCURRENT_REQUESTS_PER_CONNECTION);
        UNDERTOW_OPTIONS.add(UndertowOptions.MAX_COOKIES);
        UNDERTOW_OPTIONS.add(UndertowOptions.MAX_HEADERS);
        UNDERTOW_OPTIONS.add(UndertowOptions.MAX_HEADER_SIZE);
        UNDERTOW_OPTIONS.add(UndertowOptions.MAX_PARAMETERS);
        UNDERTOW_OPTIONS.add(UndertowOptions.MAX_QUEUED_READ_BUFFERS);
        UNDERTOW_OPTIONS.add(UndertowOptions.NO_REQUEST_TIMEOUT);
        UNDERTOW_OPTIONS.add(UndertowOptions.RECORD_REQUEST_START_TIME);
        UNDERTOW_OPTIONS.add(UndertowOptions.REQUEST_PARSE_TIMEOUT);
        UNDERTOW_OPTIONS.add(UndertowOptions.REQUIRE_HOST_HTTP11);
        UNDERTOW_OPTIONS.add(UndertowOptions.SHUTDOWN_TIMEOUT);
        UNDERTOW_OPTIONS.add(UndertowOptions.SSL_USER_CIPHER_SUITES_ORDER);
        UNDERTOW_OPTIONS.add(UndertowOptions.URL_CHARSET);
        LONG_UNDERTOW_OPTIONS = Sets.newHashSet();
        LONG_UNDERTOW_OPTIONS.add((Option<Long>)UndertowOptions.MAX_ENTITY_SIZE);
        LONG_UNDERTOW_OPTIONS.add((Option<Long>)UndertowOptions.MULTIPART_MAX_ENTITY_SIZE);
        SPLIT_REGEX = Pattern.compile("\\\\\"|\"(?:\\\\\"|[^\"])*\"|\\\\'|'(?:\\\\'|[^'])*'|(;)");
    }

    public record RhOverride(String path, Object value, String raw) {
    }
}

