/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.exchange;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import java.io.IOException;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Scanner;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.json.JsonParseException;
import org.bson.types.ObjectId;
import org.restheart.exchange.ServiceRequest;
import org.restheart.utils.BsonUtils;
import org.restheart.utils.ChannelReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BsonFromCsvRequest
extends ServiceRequest<BsonArray> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BsonFromCsvRequest.class);
    public static final String CVS_CONTENT_TYPE = "text/csv";

    protected BsonFromCsvRequest(HttpServerExchange exchange) {
        super(exchange);
    }

    public static BsonFromCsvRequest init(HttpServerExchange exchange) {
        BsonFromCsvRequest ret = new BsonFromCsvRequest(exchange);
        if (BsonFromCsvRequest.checkContentType(exchange)) {
            try {
                ret.injectContent(exchange);
            }
            catch (IOException ex) {
                LOGGER.warn("error parsing CSV", (Throwable)ex);
                ret.setInError(true);
            }
            catch (Throwable ieo) {
                LOGGER.warn("error initializing request", ieo);
                ret.setInError(true);
            }
        } else {
            LOGGER.warn("error initializing request, Contenty-Type is not {}", (Object)CVS_CONTENT_TYPE);
            ret.setInError(true);
        }
        return ret;
    }

    public static BsonFromCsvRequest of(HttpServerExchange exchange) {
        return BsonFromCsvRequest.of(exchange, BsonFromCsvRequest.class);
    }

    public void injectContent(HttpServerExchange exchange) throws IOException {
        CsvRequestParams params = new CsvRequestParams(exchange);
        String csv = ChannelReader.readString(exchange);
        this.setContent(this.parseCsv(params, csv));
    }

    private static boolean checkContentType(HttpServerExchange exchange) {
        HeaderValues contentType = exchange.getRequestHeaders().get(Headers.CONTENT_TYPE);
        return contentType != null && contentType.stream().anyMatch(ct -> ct.equals(CVS_CONTENT_TYPE) || ct.startsWith(CVS_CONTENT_TYPE.concat(";")));
    }

    private BsonArray parseCsv(CsvRequestParams params, String csv) throws IOException {
        BsonArray bson = new BsonArray();
        boolean isHeader = true;
        List<String> cols = null;
        try (Scanner scanner = new Scanner(csv);){
            while (scanner.hasNext()) {
                String line = scanner.nextLine();
                List<String> vals = Arrays.asList(line.split(params.sep + "(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)", -1));
                if (isHeader) {
                    cols = vals;
                } else {
                    BsonDocument doc = BsonUtils.document().put("_etag", new ObjectId()).get();
                    int unnamedProps = 0;
                    for (int idx = 0; idx < vals.size(); ++idx) {
                        Object propname;
                        if (idx == params.idIdx) {
                            String _v = vals.get(params.idIdx);
                            if (_v == null) continue;
                            if ("".equals(_v.strip())) {
                                _v = "\"".concat(_v).concat("\"");
                            }
                            doc.append("_id", this.getBsonValue(_v));
                            continue;
                        }
                        if (cols == null || cols.size() <= idx) {
                            propname = "unnamed_" + unnamedProps;
                            ++unnamedProps;
                        } else {
                            propname = cols.get(idx);
                        }
                        String _v = vals.get(idx);
                        if ("".equals(_v.strip())) {
                            _v = "\"".concat(_v).concat("\"");
                        }
                        if (_v == null) continue;
                        doc.append((String)propname, this.getBsonValue(_v));
                    }
                    bson.add((BsonValue)doc);
                }
                isHeader = false;
            }
        }
        return bson;
    }

    private BsonValue getBsonValue(String raw) {
        try {
            return BsonUtils.parse(raw);
        }
        catch (JsonParseException jpe) {
            return new BsonString(raw);
        }
    }

    private static class CsvRequestParams {
        private static final String ID_IDX_QPARAM_NAME = "id";
        private static final String SEPARATOR_QPARAM_NAME = "sep";
        public final int idIdx;
        public final String sep;

        CsvRequestParams(HttpServerExchange exchange) {
            Deque _sep = (Deque)exchange.getQueryParameters().get(SEPARATOR_QPARAM_NAME);
            Deque _id = (Deque)exchange.getQueryParameters().get(ID_IDX_QPARAM_NAME);
            String string = _sep != null ? (_sep.size() > 0 ? (String)_sep.getFirst() : "") : (this.sep = ",");
            String _idIdx = _id != null ? (_id.size() > 0 ? (String)_id.getFirst() : "-1") : "-1";
            try {
                this.idIdx = Integer.parseInt(_idIdx);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException(nfe);
            }
        }
    }
}

