/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.exchange;

import io.undertow.server.HttpServerExchange;
import org.bson.BsonValue;
import org.restheart.exchange.ServiceResponse;
import org.restheart.utils.BsonUtils;

public class BsonResponse
extends ServiceResponse<BsonValue> {
    protected BsonResponse(HttpServerExchange exchange) {
        super(exchange);
        this.setContentTypeAsJson();
    }

    public static BsonResponse init(HttpServerExchange exchange) {
        return new BsonResponse(exchange);
    }

    public static BsonResponse of(HttpServerExchange exchange) {
        return BsonResponse.of(exchange, BsonResponse.class);
    }

    @Override
    public String readContent() {
        if (this.content != null) {
            return BsonUtils.toJson((BsonValue)this.content);
        }
        return null;
    }

    @Override
    public void setContent(BsonUtils.ArrayBuilder builder) {
        this.setContent(builder.get());
    }

    @Override
    public void setContent(BsonUtils.DocumentBuilder builder) {
        this.setContent(builder.get());
    }

    @Override
    public void setInError(int code, String message, Throwable t) {
        this.setInError(true);
        this.setStatusCode(code);
        BsonUtils.DocumentBuilder content = BsonUtils.document();
        if (message != null) {
            content.put("msg", message);
        } else {
            content.putNull("msg");
        }
        if (t != null) {
            content.put("msg", t.getMessage());
        }
        this.setContent(content);
    }
}

