/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.exchange;

import com.google.common.reflect.TypeToken;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import org.restheart.exchange.ProxyRequest;
import org.restheart.utils.BuffersUtils;

public class ByteArrayProxyRequest
extends ProxyRequest<byte[]> {
    private static final Type _TYPE = new TypeToken<ByteArrayProxyRequest>(ByteArrayProxyRequest.class){
        private static final long serialVersionUID = 7455691404944194247L;
    }.getType();

    protected ByteArrayProxyRequest(HttpServerExchange exchange) {
        super(exchange);
    }

    public static ByteArrayProxyRequest of(HttpServerExchange exchange) {
        return new ByteArrayProxyRequest(exchange);
    }

    public static Type type() {
        return _TYPE;
    }

    @Override
    public byte[] readContent() throws IOException {
        return BuffersUtils.toByteArray(this.getBuffer());
    }

    @Override
    public void writeContent(byte[] content) throws IOException {
        if (content == null) {
            this.setBuffer(null);
        } else {
            PooledByteBuffer[] dest;
            if (this.isContentAvailable()) {
                dest = this.getBuffer();
            } else {
                dest = new PooledByteBuffer[MAX_BUFFERS];
                this.setBuffer(dest);
            }
            int copied = BuffersUtils.transfer(ByteBuffer.wrap(content), dest, this.wrapped);
            this.getHeaders().put(Headers.CONTENT_LENGTH, (long)copied);
        }
    }
}

