/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.exchange;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import org.restheart.exchange.ProxyResponse;
import org.restheart.utils.BuffersUtils;

public class ByteArrayProxyResponse
extends ProxyResponse<byte[]> {
    private static final Type _TYPE = new TypeToken<ByteArrayProxyResponse>(ByteArrayProxyResponse.class){
        private static final long serialVersionUID = -6882416842030533004L;
    }.getType();

    protected ByteArrayProxyResponse(HttpServerExchange exchange) {
        super(exchange);
    }

    public static ByteArrayProxyResponse of(HttpServerExchange exchange) {
        return new ByteArrayProxyResponse(exchange);
    }

    public static Type type() {
        return _TYPE;
    }

    @Override
    public byte[] readContent() throws IOException {
        return BuffersUtils.toByteArray(this.getBuffer());
    }

    @Override
    public void writeContent(byte[] content) throws IOException {
        if (content == null) {
            this.setBuffer(null);
        } else {
            PooledByteBuffer[] dest;
            if (this.isContentAvailable()) {
                dest = this.getBuffer();
            } else {
                dest = new PooledByteBuffer[MAX_BUFFERS];
                this.setBuffer(dest);
            }
            BuffersUtils.transfer(ByteBuffer.wrap(content), dest, this.wrapped);
        }
    }

    @Override
    protected byte[] getErrorContent(int code, String httpStatusText, String message, Throwable t, boolean includeStackTrace) throws IOException {
        JsonObject resp = new JsonObject();
        resp.add("http status code", (JsonElement)new JsonPrimitive((Number)code));
        resp.add("http status description", (JsonElement)new JsonPrimitive(httpStatusText));
        if (message != null) {
            resp.add("message", (JsonElement)new JsonPrimitive(ByteArrayProxyResponse.avoidEscapedChars(message)));
        }
        JsonObject nrep = new JsonObject();
        if (t != null) {
            JsonArray stackTrace;
            nrep.add("class", (JsonElement)new JsonPrimitive(t.getClass().getName()));
            if (includeStackTrace && (stackTrace = ByteArrayProxyResponse.getStackTrace(t)) != null) {
                nrep.add("stack trace", (JsonElement)stackTrace);
            }
            resp.add("exception", (JsonElement)nrep);
        }
        return resp.toString().getBytes();
    }

    private static String avoidEscapedChars(String s) {
        return s == null ? null : s.replaceAll("\"", "'").replaceAll("\t", "  ");
    }

    private static JsonArray getStackTrace(Throwable t) {
        if (t == null || t.getStackTrace() == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        String st = sw.toString();
        st = ByteArrayProxyResponse.avoidEscapedChars(st);
        String[] lines = st.split("\n");
        JsonArray list = new JsonArray();
        for (String line : lines) {
            list.add((JsonElement)new JsonPrimitive(line));
        }
        return list;
    }
}

