/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.exchange;

import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.restheart.exchange.ServiceRequest;
import org.restheart.utils.ChannelReader;

public class ByteArrayRequest
extends ServiceRequest<byte[]> {
    protected ByteArrayRequest(HttpServerExchange exchange) {
        super(exchange);
    }

    public static ByteArrayRequest init(HttpServerExchange exchange) {
        ByteArrayRequest ret = new ByteArrayRequest(exchange);
        try {
            ret.injectContent();
        }
        catch (IOException ieo) {
            ret.setInError(true);
        }
        return ret;
    }

    public static ByteArrayRequest of(HttpServerExchange exchange) {
        return ByteArrayRequest.of(exchange, ByteArrayRequest.class);
    }

    public void injectContent() throws IOException {
        if (this.wrapped.getRequestContentLength() > 0L) {
            this.setContent(ChannelReader.readBytes(this.wrapped));
        } else {
            this.setContent(null);
        }
    }

    public String getContentString() {
        return new String((byte[])this.getContent(), StandardCharsets.UTF_8);
    }
}

