/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.exchange;

import com.google.gson.JsonObject;
import io.undertow.server.HttpServerExchange;
import java.nio.charset.StandardCharsets;
import org.restheart.exchange.ServiceResponse;

public class ByteArrayResponse
extends ServiceResponse<byte[]> {
    protected ByteArrayResponse(HttpServerExchange exchange) {
        super(exchange);
    }

    public static ByteArrayResponse init(HttpServerExchange exchange) {
        return new ByteArrayResponse(exchange);
    }

    public static ByteArrayResponse of(HttpServerExchange exchange) {
        return ByteArrayResponse.of(exchange, ByteArrayResponse.class);
    }

    @Override
    public String readContent() {
        if (this.content != null) {
            return new String((byte[])this.content, StandardCharsets.UTF_8);
        }
        return null;
    }

    @Override
    public void setInError(int code, String message, Throwable t) {
        this.setInError(true);
        this.setStatusCode(code);
        JsonObject resp = new JsonObject();
        if (message != null) {
            resp.addProperty("msg", message);
        }
        if (t != null) {
            resp.addProperty("exception", t.getMessage());
        }
        this.setContentTypeAsJson();
        this.setContent(resp.toString().getBytes());
    }

    @Override
    public void setContent(String content) {
        if (content != null) {
            this.setContent(content.getBytes());
        } else {
            this.setContent((byte[])null);
        }
    }
}

