/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.exchange;

import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import org.restheart.exchange.Request;
import org.restheart.plugins.security.TokenManager;

public interface CORSHeaders {
    public static final HttpString ACCESS_CONTROL_EXPOSE_HEADERS = HttpString.tryFromString((String)"Access-Control-Expose-Headers");
    public static final HttpString ACCESS_CONTROL_ALLOW_CREDENTIAL = HttpString.tryFromString((String)"Access-Control-Allow-Credentials");
    public static final HttpString ACCESS_CONTROL_ALLOW_ORIGIN = HttpString.tryFromString((String)"Access-Control-Allow-Origin");
    public static final HttpString ACCESS_CONTROL_ALLOW_METHODS = HttpString.tryFromString((String)"Access-Control-Allow-Methods");
    public static final HttpString ACCESS_CONTROL_ALLOW_HEADERS = HttpString.tryFromString((String)"Access-Control-Allow-Headers");
    public static final String DEFAULT_ACCESS_CONTROL_EXPOSE_HEADERS = "Location, " + Headers.ETAG.toString() + ", " + TokenManager.AUTH_TOKEN_HEADER.toString() + ", " + TokenManager.AUTH_TOKEN_VALID_HEADER.toString() + ", " + TokenManager.AUTH_TOKEN_LOCATION_HEADER.toString() + ", X-Powered-By";
    public static final String DEFAULT_ACCESS_CONTROL_ALLOW_CREDENTIALS = "true";
    public static final String DEFAULT_ACCESS_CONTROL_ALLOW_ORIGIN = "*";
    public static final String DEFAULT_ACCESS_CONTROL_ALLOW_METHODS = "GET, PUT, POST, PATCH, DELETE, OPTIONS";
    public static final String DEFAULT_ACCESS_CONTROL_ALLOW_HEADERS = "Accept, Accept-Encoding, Authorization, Content-Length, Content-Type, Host, If-Match, Origin, X-Requested-With, User-Agent, No-Auth-Challenge";

    default public String accessControlExposeHeaders(Request<?> r) {
        return DEFAULT_ACCESS_CONTROL_EXPOSE_HEADERS;
    }

    default public String accessControlAllowCredentials(Request<?> r) {
        return DEFAULT_ACCESS_CONTROL_ALLOW_CREDENTIALS;
    }

    default public String accessControlAllowOrigin(Request<?> r) {
        HeaderMap requestHeaders = r.getHeaders();
        if (requestHeaders.contains(Headers.ORIGIN)) {
            return requestHeaders.get(Headers.ORIGIN).getFirst().toString();
        }
        return DEFAULT_ACCESS_CONTROL_ALLOW_ORIGIN;
    }

    default public String accessControlAllowMethods(Request<?> r) {
        return DEFAULT_ACCESS_CONTROL_ALLOW_METHODS;
    }

    default public String accessControlAllowHeaders(Request<?> r) {
        return DEFAULT_ACCESS_CONTROL_ALLOW_HEADERS;
    }
}

