/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.exchange;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;

public abstract class Exchange<T> {
    public static final String HAL_JSON_MEDIA_TYPE = "application/hal+json";
    public static final String JSON_MEDIA_TYPE = "application/json";
    public static final String APPLICATION_PDF_TYPE = "application/pdf";
    public static final String FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final String MULTIPART = "multipart/form-data";
    protected static final AttachmentKey<Boolean> IN_ERROR_KEY = AttachmentKey.create(Boolean.class);
    private static final AttachmentKey<Boolean> RESPONSE_INTERCEPTOR_EXECUTED = AttachmentKey.create(Boolean.class);
    public static final int MAX_CONTENT_SIZE = 0x1000000;
    public static int MAX_BUFFERS = 1024;
    protected final HttpServerExchange wrapped;

    public static void updateBufferSize(int bufferSize) {
        MAX_BUFFERS = 1 + 0x1000000 / bufferSize;
    }

    public Exchange(HttpServerExchange exchange) {
        this.wrapped = exchange;
    }

    protected HttpServerExchange getWrappedExchange() {
        return this.wrapped;
    }

    public static boolean isInError(HttpServerExchange exchange) {
        return exchange.getAttachment(IN_ERROR_KEY) != null && (Boolean)exchange.getAttachment(IN_ERROR_KEY) != false;
    }

    public static boolean isAuthenticated(HttpServerExchange exchange) {
        return exchange.getSecurityContext() != null && exchange.getSecurityContext().getAuthenticatedAccount() != null;
    }

    public static void setInError(HttpServerExchange exchange) {
        exchange.putAttachment(IN_ERROR_KEY, (Object)true);
    }

    public static boolean responseInterceptorsExecuted(HttpServerExchange exchange) {
        return exchange.getAttachment(RESPONSE_INTERCEPTOR_EXECUTED) != null && (Boolean)exchange.getAttachment(RESPONSE_INTERCEPTOR_EXECUTED) != false;
    }

    public static void setResponseInterceptorsExecuted(HttpServerExchange exchange) {
        exchange.putAttachment(RESPONSE_INTERCEPTOR_EXECUTED, (Object)true);
    }

    public HttpServerExchange getExchange() {
        return this.wrapped;
    }

    public abstract String getContentType();

    public boolean isContentTypeJson() {
        return JSON_MEDIA_TYPE.equals(this.getContentType()) || this.getContentType() != null && this.getContentType().startsWith("application/json;");
    }

    public boolean isInError() {
        return this.getWrappedExchange().getAttachment(IN_ERROR_KEY) != null && (Boolean)this.getWrappedExchange().getAttachment(IN_ERROR_KEY) != false;
    }

    public void setInError(boolean inError) {
        this.getWrappedExchange().putAttachment(IN_ERROR_KEY, (Object)inError);
    }

    public boolean isContentTypeXml() {
        return "text/xml".equals(this.getContentType()) || this.getContentType() != null && this.getContentType().startsWith("text/xml;") || "application/xml".equals(this.getContentType()) || this.getContentType() != null && this.getContentType().startsWith("application/xml;");
    }

    public boolean isContentTypeText() {
        return this.getContentType() != null && this.getContentType().startsWith("text/");
    }

    public static boolean isContentTypeJson(HttpServerExchange exchange) {
        String ct = exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
        return JSON_MEDIA_TYPE.equals(ct) || ct != null && ct.startsWith("application/json;");
    }

    public static boolean isContentTypeFormOrMultipart(HttpServerExchange exchange) {
        String ct = exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
        return ct != null && (ct.startsWith(FORM_URLENCODED) || ct.startsWith(MULTIPART));
    }

    public boolean isContentTypeFormOrMultipart() {
        return Exchange.isContentTypeFormOrMultipart(this.wrapped);
    }

    public boolean isAuthenticated() {
        return this.getWrappedExchange().getSecurityContext() != null && this.getWrappedExchange().getSecurityContext().getAuthenticatedAccount() != null;
    }

    public boolean isAccountInRole(String role) {
        if (!this.isAuthenticated()) {
            return false;
        }
        if (this.getWrappedExchange().getSecurityContext().getAuthenticatedAccount().getRoles() == null) {
            return false;
        }
        return this.getWrappedExchange().getSecurityContext().getAuthenticatedAccount().getRoles().contains(role);
    }
}

