/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.exchange;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.IOException;
import org.restheart.exchange.BadRequestException;
import org.restheart.exchange.ServiceRequest;
import org.restheart.utils.ChannelReader;

public class GraphQLRequest
extends ServiceRequest<JsonElement> {
    private static final String GRAPHQL_CONTENT_TYPE = "application/graphql";
    private static final String QUERY_FIELD = "query";
    private static final String OPERATION_NAME_FIELD = "operationName";
    private static final String VARIABLES_FIELD = "variables";
    private final String appUri;

    private GraphQLRequest(HttpServerExchange exchange, String appUri) {
        super(exchange);
        this.appUri = appUri;
    }

    public static GraphQLRequest init(HttpServerExchange exchange, String appUri) throws IOException, JsonSyntaxException, BadRequestException {
        GraphQLRequest ret = new GraphQLRequest(exchange, appUri);
        HttpString method = exchange.getRequestMethod();
        if (!method.equalToString("OPTIONS") && !method.equalToString("POST")) {
            throw new BadRequestException("Method not allowed", 405);
        }
        if (GraphQLRequest.isContentTypeGraphQL(exchange)) {
            ret.injectContentGraphQL();
        } else if (GraphQLRequest.isContentTypeJson(exchange)) {
            ret.injectContentJson();
        } else if (!method.equalToString("OPTIONS")) {
            throw new BadRequestException("Bad request: " + Headers.CONTENT_TYPE + " must be either application/graphql or application/json", 400);
        }
        return ret;
    }

    public static GraphQLRequest of(HttpServerExchange exchange) {
        return GraphQLRequest.of(exchange, GraphQLRequest.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void injectContentJson() throws IOException, JsonSyntaxException, BadRequestException {
        String body = ChannelReader.readString(this.wrapped);
        JsonElement json = JsonParser.parseString((String)body);
        if (!json.isJsonObject() || !json.getAsJsonObject().has(QUERY_FIELD)) throw new BadRequestException("missing query field", 400);
        if (!json.getAsJsonObject().get(QUERY_FIELD).isJsonPrimitive()) throw new BadRequestException("query field must be a string", 400);
        if (!json.getAsJsonObject().get(QUERY_FIELD).getAsJsonPrimitive().isString()) {
            throw new BadRequestException("query field must be a string", 400);
        }
        this.setContent(json);
    }

    private void injectContentGraphQL() throws IOException {
        String body = ChannelReader.readString(this.wrapped);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(QUERY_FIELD, body);
        this.setContent(jsonObject);
    }

    public String getQuery() {
        if (((JsonElement)this.getContent()).isJsonObject() && ((JsonElement)this.getContent()).getAsJsonObject().has(QUERY_FIELD) && ((JsonElement)this.getContent()).getAsJsonObject().get(QUERY_FIELD).isJsonPrimitive() && ((JsonElement)this.getContent()).getAsJsonObject().getAsJsonPrimitive(QUERY_FIELD).isString()) {
            return ((JsonElement)this.getContent()).getAsJsonObject().getAsJsonPrimitive(QUERY_FIELD).getAsString();
        }
        return null;
    }

    public String getOperationName() {
        if (((JsonElement)this.getContent()).isJsonObject() && ((JsonElement)this.getContent()).getAsJsonObject().has(OPERATION_NAME_FIELD) && ((JsonElement)this.getContent()).getAsJsonObject().get(OPERATION_NAME_FIELD).isJsonPrimitive() && ((JsonElement)this.getContent()).getAsJsonObject().getAsJsonPrimitive(OPERATION_NAME_FIELD).isString()) {
            return ((JsonElement)this.getContent()).getAsJsonObject().getAsJsonPrimitive(OPERATION_NAME_FIELD).getAsString();
        }
        return null;
    }

    public JsonObject getVariables() {
        if (((JsonElement)this.getContent()).isJsonObject() && ((JsonElement)this.getContent()).getAsJsonObject().has(VARIABLES_FIELD) && ((JsonElement)this.getContent()).getAsJsonObject().get(VARIABLES_FIELD).isJsonObject()) {
            return ((JsonElement)this.getContent()).getAsJsonObject().getAsJsonObject(VARIABLES_FIELD);
        }
        return null;
    }

    public String getGraphQLAppURI() {
        return this.appUri;
    }

    public boolean hasVariables() {
        return ((JsonElement)this.getContent()).isJsonObject() && ((JsonElement)this.getContent()).getAsJsonObject().has(VARIABLES_FIELD) && ((JsonElement)this.getContent()).getAsJsonObject().get(VARIABLES_FIELD).isJsonObject();
    }

    private static boolean isContentTypeGraphQL(HttpServerExchange exchange) {
        String contentType = GraphQLRequest.getContentType(exchange);
        return GRAPHQL_CONTENT_TYPE.equals(contentType) || contentType != null && contentType.startsWith(GRAPHQL_CONTENT_TYPE);
    }
}

