/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.exchange;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.restheart.exchange.ProxyRequest;
import org.restheart.utils.BuffersUtils;

public class JsonProxyRequest
extends ProxyRequest<JsonElement> {
    protected JsonProxyRequest(HttpServerExchange exchange) {
        super(exchange);
    }

    public static JsonProxyRequest of(HttpServerExchange exchange) {
        return new JsonProxyRequest(exchange);
    }

    @Override
    public JsonElement readContent() throws IOException {
        if (!this.isContentAvailable()) {
            return null;
        }
        if (this.getWrappedExchange().getAttachment(this.getRawContentKey()) == null) {
            return JsonNull.INSTANCE;
        }
        try {
            return JsonParser.parseString((String)BuffersUtils.toString(this.getBuffer(), StandardCharsets.UTF_8));
        }
        catch (JsonParseException ex) {
            BuffersUtils.dump("Error parsing content", this.getBuffer());
            throw new IOException("Error parsing json", ex);
        }
    }

    @Override
    public void writeContent(JsonElement content) throws IOException {
        this.setContentTypeAsJson();
        if (content == null) {
            this.setBuffer(null);
            this.getHeaders().remove(Headers.CONTENT_LENGTH);
        } else {
            PooledByteBuffer[] dest;
            if (this.isContentAvailable()) {
                dest = this.getBuffer();
            } else {
                dest = new PooledByteBuffer[MAX_BUFFERS];
                this.setBuffer(dest);
            }
            int copied = BuffersUtils.transfer(ByteBuffer.wrap(content.toString().getBytes()), dest, this.wrapped);
            this.getHeaders().put(Headers.CONTENT_LENGTH, (long)copied);
        }
    }
}

