/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.exchange;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.restheart.exchange.ProxyResponse;
import org.restheart.utils.BuffersUtils;

public class JsonProxyResponse
extends ProxyResponse<JsonElement> {
    protected JsonProxyResponse(HttpServerExchange exchange) {
        super(exchange);
    }

    public static JsonProxyResponse of(HttpServerExchange exchange) {
        return new JsonProxyResponse(exchange);
    }

    @Override
    public JsonElement readContent() throws IOException {
        if (!this.isContentAvailable()) {
            return null;
        }
        if (this.getWrappedExchange().getAttachment(this.getRawContentKey()) == null) {
            return JsonNull.INSTANCE;
        }
        try {
            return JsonParser.parseString((String)BuffersUtils.toString(this.getBuffer(), StandardCharsets.UTF_8));
        }
        catch (JsonParseException ex) {
            throw new IOException("Error parsing json", ex);
        }
    }

    @Override
    public void writeContent(JsonElement content) throws IOException {
        this.setContentTypeAsJson();
        if (content == null) {
            this.setBuffer(null);
        } else {
            PooledByteBuffer[] dest;
            if (this.isContentAvailable()) {
                dest = this.getBuffer();
            } else {
                dest = new PooledByteBuffer[MAX_BUFFERS];
                this.setBuffer(dest);
            }
            BuffersUtils.transfer(ByteBuffer.wrap(content.toString().getBytes()), dest, this.wrapped);
        }
    }

    @Override
    protected JsonElement getErrorContent(int code, String httpStatusText, String message, Throwable t, boolean includeStackTrace) throws IOException {
        JsonObject resp = new JsonObject();
        resp.add("http status code", (JsonElement)new JsonPrimitive((Number)code));
        resp.add("http status description", (JsonElement)new JsonPrimitive(httpStatusText));
        if (message != null) {
            resp.add("message", (JsonElement)new JsonPrimitive(JsonProxyResponse.avoidEscapedChars(message)));
        }
        JsonObject nrep = new JsonObject();
        if (t != null) {
            JsonArray stackTrace;
            nrep.add("class", (JsonElement)new JsonPrimitive(t.getClass().getName()));
            if (includeStackTrace && (stackTrace = JsonProxyResponse.getStackTrace(t)) != null) {
                nrep.add("stack trace", (JsonElement)stackTrace);
            }
            resp.add("exception", (JsonElement)nrep);
        }
        return resp;
    }

    private static String avoidEscapedChars(String s) {
        return s == null ? null : s.replaceAll("\"", "'").replaceAll("\t", "  ");
    }

    private static JsonArray getStackTrace(Throwable t) {
        if (t == null || t.getStackTrace() == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        String st = JsonProxyResponse.avoidEscapedChars(sw.toString());
        String[] lines = st.split("\n");
        JsonArray list = new JsonArray();
        for (String line : lines) {
            list.add((JsonElement)new JsonPrimitive(line));
        }
        return list;
    }
}

