/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.exchange;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import org.restheart.exchange.ServiceRequest;
import org.restheart.utils.ChannelReader;

public class JsonRequest
extends ServiceRequest<JsonElement> {
    protected JsonRequest(HttpServerExchange exchange) {
        super(exchange);
    }

    public static JsonRequest init(HttpServerExchange exchange) {
        JsonRequest ret = new JsonRequest(exchange);
        try {
            ret.injectContent();
        }
        catch (Throwable ieo) {
            ret.setInError(true);
        }
        return ret;
    }

    public static JsonRequest of(HttpServerExchange exchange) {
        return JsonRequest.of(exchange, JsonRequest.class);
    }

    public void injectContent() throws IOException {
        if (this.wrapped.getRequestContentLength() > 0L) {
            this.setContent(JsonParser.parseString((String)ChannelReader.readString(this.wrapped)));
        } else {
            this.setContent(null);
        }
    }
}

