/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.exchange;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.undertow.server.HttpServerExchange;
import org.restheart.exchange.ServiceResponse;
import org.restheart.utils.GsonUtils;

public class JsonResponse
extends ServiceResponse<JsonElement> {
    protected JsonResponse(HttpServerExchange exchange) {
        super(exchange);
        this.setContentTypeAsJson();
    }

    public static JsonResponse init(HttpServerExchange exchange) {
        return new JsonResponse(exchange);
    }

    public static JsonResponse of(HttpServerExchange exchange) {
        return JsonResponse.of(exchange, JsonResponse.class);
    }

    @Override
    public String readContent() {
        if (this.content != null) {
            return ((JsonElement)this.content).toString();
        }
        return null;
    }

    @Override
    public void setContent(GsonUtils.ObjectBuilder builder) {
        if (builder != null) {
            this.setContent(builder.get());
        }
    }

    @Override
    public void setContent(GsonUtils.ArrayBuilder builder) {
        if (builder != null) {
            this.setContent(builder.get());
        }
    }

    @Override
    public void setInError(int code, String message, Throwable t) {
        this.setInError(true);
        this.setStatusCode(code);
        JsonObject resp = new JsonObject();
        if (message != null) {
            resp.addProperty("msg", message);
        }
        if (t != null) {
            resp.addProperty("exception", t.getMessage());
        }
        this.setContent(resp);
    }
}

