/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.exchange;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.PathTemplateMatch;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Deque;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.json.JsonMode;
import org.bson.json.JsonParseException;
import org.restheart.exchange.BsonRequest;
import org.restheart.exchange.ExchangeKeys;
import org.restheart.exchange.MongoRequestContentInjector;
import org.restheart.mongodb.RSOps;
import org.restheart.mongodb.db.sessions.ClientSessionImpl;
import org.restheart.utils.BsonUtils;
import org.restheart.utils.MongoServiceAttachments;
import org.restheart.utils.URLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoRequest
extends BsonRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoRequest.class);
    private final String whereUri;
    private final String whatUri;
    private final String[] pathTokens;
    private BsonDocument dbProps;
    private BsonDocument collectionProps;
    private InputStream fileInputStream;
    private int page = 1;
    private int pagesize = 100;
    private boolean count = false;
    private boolean etagCheckRequired = false;
    private ExchangeKeys.WRITE_MODE writeMode = null;
    private boolean cache;
    private Deque<String> filter = null;
    private BsonDocument aggregationVars = null;
    private Deque<String> keys = null;
    private Deque<String> sortBy = null;
    private Deque<String> hint = null;
    private ExchangeKeys.DOC_ID_TYPE docIdType = ExchangeKeys.DOC_ID_TYPE.STRING_OID;
    private final ExchangeKeys.TYPE type;
    private ExchangeKeys.REPRESENTATION_FORMAT representationFormat;
    private BsonValue documentId;
    private String mappedUri = null;
    private String unmappedUri = null;
    private final String etag;
    private boolean forceEtagCheck = false;
    private BsonDocument shardKey = null;
    private boolean noProps = false;
    private ClientSessionImpl clientSession = null;
    private ExchangeKeys.HAL_MODE halMode = ExchangeKeys.HAL_MODE.FULL;
    private final long requestStartTime = System.currentTimeMillis();
    private final PathTemplateMatch pathTemplateMatch;
    private final JsonMode jsonMode;
    final boolean noCache;
    private final Optional<RSOps> rsOps;
    public static final AttachmentKey<Boolean> CONTENT_INJECTED = AttachmentKey.create(Boolean.class);

    protected MongoRequest(HttpServerExchange exchange, String requestUri, String resourceUri) {
        super(exchange);
        ExchangeKeys.WRITE_MODE mode;
        String _jsonMode;
        this.setContentInjected(false);
        this.whereUri = URLUtils.removeTrailingSlashes(requestUri == null ? null : (requestUri.startsWith("/") ? requestUri : "/" + requestUri));
        this.whatUri = URLUtils.removeTrailingSlashes(resourceUri == null ? null : (resourceUri.startsWith("/") || "*".equals(resourceUri) ? resourceUri : "/" + resourceUri));
        this.mappedUri = exchange.getRequestPath();
        this.pathTemplateMatch = exchange.getAttachment(PathTemplateMatch.ATTACHMENT_KEY) != null ? (PathTemplateMatch)exchange.getAttachment(PathTemplateMatch.ATTACHMENT_KEY) : null;
        this.unmappedUri = this.unmapUri(exchange.getRequestPath());
        this.pathTokens = this.unmappedUri.split("/");
        this.type = MongoRequest.selectRequestType(this.pathTokens);
        HeaderValues etagHvs = this.getHeaders() == null ? null : this.getHeaders().get(Headers.IF_MATCH);
        this.etag = etagHvs == null || etagHvs.getFirst() == null ? null : etagHvs.getFirst();
        this.forceEtagCheck = exchange.getQueryParameters().get("checkEtag") != null;
        this.cache = exchange.getQueryParameters().get("cache") != null;
        this.noProps = exchange.getQueryParameters().get("np") != null;
        String string = _jsonMode = exchange.getQueryParameters().containsKey("jsonMode") ? ((String)((Deque)exchange.getQueryParameters().get("jsonMode")).getFirst()).toUpperCase() : null;
        if (_jsonMode != null) {
            JsonMode mode2;
            try {
                mode2 = JsonMode.valueOf((String)_jsonMode.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                mode2 = null;
            }
            this.jsonMode = mode2;
        } else {
            this.jsonMode = null;
        }
        boolean bl = this.noCache = exchange.getQueryParameters().get("nocache") != null;
        String _writeMode = exchange.getQueryParameters().containsKey("writeMode") ? ((String)((Deque)exchange.getQueryParameters().get("writeMode")).getFirst()).toUpperCase() : (exchange.getQueryParameters().containsKey("wm") ? ((String)((Deque)exchange.getQueryParameters().get("wm")).getFirst()).toUpperCase() : this.defaultWriteMode());
        try {
            mode = ExchangeKeys.WRITE_MODE.valueOf(_writeMode.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            mode = ExchangeKeys.WRITE_MODE.valueOf(this.defaultWriteMode());
        }
        this.writeMode = mode;
        boolean anyRsSet = false;
        RSOps _rsOps = new RSOps();
        if (exchange.getQueryParameters().containsKey("readConcern")) {
            try {
                _rsOps = _rsOps.withReadConcern((String)((Deque)exchange.getQueryParameters().get("readConcern")).getFirst());
                anyRsSet = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (exchange.getQueryParameters().containsKey("readPreference")) {
            try {
                _rsOps = _rsOps.withReadPreference((String)((Deque)exchange.getQueryParameters().get("readPreference")).getFirst());
                anyRsSet = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (exchange.getQueryParameters().containsKey("writeConcern")) {
            _rsOps = _rsOps.withWriteConcern((String)((Deque)exchange.getQueryParameters().get("writeConcern")).getFirst());
            anyRsSet = true;
        }
        this.rsOps = anyRsSet ? Optional.of(_rsOps) : Optional.empty();
        LOGGER.debug("ReplicaSet connection options: {}", (Object)_rsOps);
    }

    private String defaultWriteMode() {
        if (this.isPost()) {
            return ExchangeKeys.WRITE_MODE.INSERT.name();
        }
        if (this.isPatch() || this.isPut()) {
            return ExchangeKeys.WRITE_MODE.UPDATE.name();
        }
        return ExchangeKeys.WRITE_MODE.UPSERT.name();
    }

    public static MongoRequest init(HttpServerExchange exchange, String requestUri, String resourceUri) {
        return new MongoRequest(exchange, requestUri, resourceUri);
    }

    public static MongoRequest of(HttpServerExchange exchange) {
        return MongoRequest.of(exchange, MongoRequest.class);
    }

    public static boolean isReservedDbName(String dbName) {
        return dbName == null ? false : "".equals(dbName) || dbName.equalsIgnoreCase("admin") || dbName.equalsIgnoreCase("config") || dbName.equalsIgnoreCase("local") || dbName.startsWith("system.");
    }

    public static boolean isReservedCollectionName(String collectionName) {
        return collectionName == null ? false : "".equals(collectionName) || collectionName.startsWith("system.") || collectionName.endsWith(".chunks") || collectionName.equals("_properties");
    }

    public static boolean isReservedDocumentId(ExchangeKeys.TYPE type, BsonValue documentId) {
        if (documentId == null || !documentId.isString()) {
            return false;
        }
        String sdi = documentId.asString().getValue();
        if (type == ExchangeKeys.TYPE.COLLECTION_META && sdi.startsWith("_properties.") || type == ExchangeKeys.TYPE.DB_META && sdi.startsWith("_properties") || type == ExchangeKeys.TYPE.BULK_DOCUMENTS && "*".equals(sdi) || type == ExchangeKeys.TYPE.METRICS && "_metrics".equalsIgnoreCase(sdi) || type == ExchangeKeys.TYPE.COLLECTION_SIZE && "_size".equalsIgnoreCase(sdi) || type == ExchangeKeys.TYPE.INDEX && "_indexes".equalsIgnoreCase(sdi) || type == ExchangeKeys.TYPE.COLLECTION_META && "_meta".equalsIgnoreCase(sdi) || type == ExchangeKeys.TYPE.INVALID && "_aggrs".equalsIgnoreCase(sdi) || type == ExchangeKeys.TYPE.INVALID && "_streams".equalsIgnoreCase(sdi)) {
            return false;
        }
        return "_properties".equalsIgnoreCase(sdi) || sdi.startsWith("_properties.");
    }

    public ExchangeKeys.TYPE getType() {
        return this.type;
    }

    static ExchangeKeys.TYPE selectRequestType(String[] pathTokens) {
        ExchangeKeys.TYPE type = pathTokens.length > 0 && pathTokens[pathTokens.length - 1].equalsIgnoreCase("_size") ? (pathTokens.length == 2 ? ExchangeKeys.TYPE.ROOT_SIZE : (pathTokens.length == 3 ? ExchangeKeys.TYPE.DB_SIZE : (pathTokens.length == 4 && pathTokens[2].endsWith(".files") ? ExchangeKeys.TYPE.FILES_BUCKET_SIZE : (pathTokens.length == 4 && pathTokens[2].equalsIgnoreCase("_schemas") ? ExchangeKeys.TYPE.SCHEMA_STORE_SIZE : (pathTokens.length == 4 ? ExchangeKeys.TYPE.COLLECTION_SIZE : ExchangeKeys.TYPE.INVALID))))) : (pathTokens.length > 2 && pathTokens[pathTokens.length - 1].equalsIgnoreCase("_meta") ? (pathTokens.length == 3 ? ExchangeKeys.TYPE.DB_META : (pathTokens.length == 4 && pathTokens[2].endsWith(".files") ? ExchangeKeys.TYPE.FILES_BUCKET_META : (pathTokens.length == 4 && pathTokens[2].equalsIgnoreCase("_schemas") ? ExchangeKeys.TYPE.SCHEMA_STORE_META : (pathTokens.length == 4 ? ExchangeKeys.TYPE.COLLECTION_META : ExchangeKeys.TYPE.INVALID)))) : (pathTokens.length < 2 ? ExchangeKeys.TYPE.ROOT : (pathTokens.length == 2 && pathTokens[pathTokens.length - 1].equalsIgnoreCase("_sessions") ? ExchangeKeys.TYPE.SESSIONS : (pathTokens.length == 3 && pathTokens[pathTokens.length - 2].equalsIgnoreCase("_sessions") ? ExchangeKeys.TYPE.SESSION : (pathTokens.length == 4 && pathTokens[pathTokens.length - 3].equalsIgnoreCase("_sessions") && pathTokens[pathTokens.length - 1].equalsIgnoreCase("_txns") ? ExchangeKeys.TYPE.TRANSACTIONS : (pathTokens.length == 5 && pathTokens[pathTokens.length - 4].equalsIgnoreCase("_sessions") && pathTokens[pathTokens.length - 2].equalsIgnoreCase("_txns") ? ExchangeKeys.TYPE.TRANSACTION : (pathTokens.length < 3 && pathTokens[1].equalsIgnoreCase("_metrics") ? ExchangeKeys.TYPE.METRICS : (pathTokens.length < 3 ? ExchangeKeys.TYPE.DB : (pathTokens.length >= 3 && pathTokens[2].endsWith(".files") ? (pathTokens.length == 3 ? ExchangeKeys.TYPE.FILES_BUCKET : (pathTokens.length == 4 && pathTokens[3].equalsIgnoreCase("_indexes") ? ExchangeKeys.TYPE.COLLECTION_INDEXES : (pathTokens.length == 4 && !pathTokens[3].equalsIgnoreCase("_indexes") && !pathTokens[3].equals("*") ? ExchangeKeys.TYPE.FILE : (pathTokens.length > 4 && pathTokens[3].equalsIgnoreCase("_indexes") ? ExchangeKeys.TYPE.INDEX : (pathTokens.length > 4 && pathTokens[3].equalsIgnoreCase("_aggrs") ? ExchangeKeys.TYPE.AGGREGATION : (pathTokens.length > 4 && !pathTokens[3].equalsIgnoreCase("_indexes") && !pathTokens[4].equalsIgnoreCase("binary") ? ExchangeKeys.TYPE.FILE : (pathTokens.length == 5 && pathTokens[4].equalsIgnoreCase("binary") ? ExchangeKeys.TYPE.FILE_BINARY : ExchangeKeys.TYPE.DOCUMENT))))))) : (pathTokens.length >= 3 && pathTokens[2].equalsIgnoreCase("_schemas") ? (pathTokens.length == 3 ? ExchangeKeys.TYPE.SCHEMA_STORE : (pathTokens[3].equals("*") ? ExchangeKeys.TYPE.BULK_DOCUMENTS : ExchangeKeys.TYPE.SCHEMA)) : (pathTokens.length >= 3 && pathTokens[2].equalsIgnoreCase("_metrics") ? ExchangeKeys.TYPE.METRICS : (pathTokens.length < 4 ? ExchangeKeys.TYPE.COLLECTION : (pathTokens.length == 4 && pathTokens[3].equalsIgnoreCase("_metrics") ? ExchangeKeys.TYPE.METRICS : (pathTokens.length == 4 && pathTokens[3].equalsIgnoreCase("_indexes") ? ExchangeKeys.TYPE.COLLECTION_INDEXES : (pathTokens.length == 4 && pathTokens[3].equals("*") ? ExchangeKeys.TYPE.BULK_DOCUMENTS : (pathTokens.length > 4 && pathTokens[3].equalsIgnoreCase("_indexes") ? ExchangeKeys.TYPE.INDEX : (pathTokens.length == 4 && pathTokens[3].equalsIgnoreCase("_aggrs") ? ExchangeKeys.TYPE.INVALID : (pathTokens.length > 4 && pathTokens[3].equalsIgnoreCase("_aggrs") ? ExchangeKeys.TYPE.AGGREGATION : (pathTokens.length == 4 && pathTokens[3].equalsIgnoreCase("_streams") ? ExchangeKeys.TYPE.INVALID : (pathTokens.length > 4 && pathTokens[3].equalsIgnoreCase("_streams") ? ExchangeKeys.TYPE.CHANGE_STREAM : ExchangeKeys.TYPE.DOCUMENT))))))))))))))))))));
        return type;
    }

    private String unmapUri(String mappedUri) {
        if (mappedUri.startsWith("/".concat("_sessions"))) {
            return mappedUri;
        }
        if (this.pathTemplateMatch == null) {
            return this.unmapPathUri(mappedUri);
        }
        return this.unmapPathTemplateUri(mappedUri);
    }

    private String unmapPathUri(String mappedUri) {
        String ret = URLUtils.removeTrailingSlashes(mappedUri);
        if (this.whatUri.equals("*")) {
            if (!this.whereUri.equals("/")) {
                ret = ret.replaceFirst("^" + this.whereUri, "");
            }
        } else {
            ret = !this.whereUri.equals("/") ? URLUtils.removeTrailingSlashes(ret.replaceFirst("^" + this.whereUri, this.whatUri)) : URLUtils.removeTrailingSlashes(URLUtils.removeTrailingSlashes(this.whatUri) + ret);
        }
        return ret.isEmpty() ? "/" : ret;
    }

    private String unmapPathTemplateUri(String mappedUri) {
        String ret = URLUtils.removeTrailingSlashes(mappedUri);
        String rewriteUri = this.replaceParamsWithActualValues();
        String replacedWhatUri = this.replaceParamsWithinWhatUri();
        if (replacedWhatUri.equals("*")) {
            if (!this.whereUri.equals("/")) {
                ret = ret.replaceFirst("^" + rewriteUri, "");
            }
        } else {
            ret = !this.whereUri.equals("/") ? URLUtils.removeTrailingSlashes(ret.replaceFirst("^" + rewriteUri, replacedWhatUri)) : URLUtils.removeTrailingSlashes(URLUtils.removeTrailingSlashes(replacedWhatUri) + ret);
        }
        return ret.isEmpty() ? "/" : ret;
    }

    public String mapUri(String unmappedUri) {
        if (this.pathTemplateMatch == null) {
            return this.mapPathUri(unmappedUri);
        }
        return this.mapPathTemplateUri(unmappedUri);
    }

    private String mapPathUri(String unmappedUri) {
        String ret = URLUtils.removeTrailingSlashes(unmappedUri);
        if (this.whatUri.equals("*")) {
            if (!this.whereUri.equals("/")) {
                return this.whereUri + unmappedUri;
            }
        } else {
            ret = URLUtils.removeTrailingSlashes(ret.replaceFirst("^" + this.whatUri, this.whereUri));
        }
        ret = ret.isEmpty() ? "/" : ret.replaceAll("//", "/");
        return ret;
    }

    private String mapPathTemplateUri(String unmappedUri) {
        String ret = URLUtils.removeTrailingSlashes(unmappedUri);
        String rewriteUri = this.replaceParamsWithActualValues();
        String replacedWhatUri = this.replaceParamsWithinWhatUri();
        if (replacedWhatUri.equals("*")) {
            if (!this.whereUri.equals("/")) {
                return rewriteUri + unmappedUri;
            }
        } else {
            ret = URLUtils.removeTrailingSlashes(ret.replaceFirst("^" + replacedWhatUri, rewriteUri));
        }
        return ret.isEmpty() ? "/" : ret;
    }

    private String replaceParamsWithinWhatUri() {
        String uri = this.whatUri;
        for (String key : this.pathTemplateMatch.getParameters().keySet()) {
            uri = uri.replace("{".concat(key).concat("}"), (CharSequence)this.pathTemplateMatch.getParameters().get(key));
        }
        return uri;
    }

    private String replaceParamsWithActualValues() {
        String rewriteUri = this.pathTemplateMatch.getMatchedTemplate();
        if (rewriteUri.endsWith("/*")) {
            rewriteUri = rewriteUri.substring(0, rewriteUri.length() - 2);
        }
        this.pathTemplateMatch.getParameters().keySet().stream().filter(key -> !key.equals("*")).collect(Collectors.toMap(key -> key, key -> (String)this.pathTemplateMatch.getParameters().get(key)));
        for (String key2 : this.pathTemplateMatch.getParameters().keySet()) {
            rewriteUri = rewriteUri.replace("{".concat(key2).concat("}"), (CharSequence)this.pathTemplateMatch.getParameters().get(key2));
        }
        return rewriteUri;
    }

    public boolean isParentAccessible() {
        return this.getType() == ExchangeKeys.TYPE.DB ? this.mappedUri.split("/").length > 1 : this.mappedUri.split("/").length > 2;
    }

    public String getDBName() {
        return this.getPathTokenAt(1);
    }

    public String getCollectionName() {
        return this.getPathTokenAt(2);
    }

    public String getDocumentIdRaw() {
        return this.getPathTokenAt(3);
    }

    public String getIndexId() {
        return this.getPathTokenAt(4);
    }

    public String getSid() {
        return this.isTxn() || this.isTxns() || this.isSessions() ? this.getPathTokenAt(2) : null;
    }

    public Long getTxnId() {
        return this.isTxn() ? Long.valueOf(this.getPathTokenAt(4)) : null;
    }

    public String getAggregationOperation() {
        return this.getPathTokenAt(4);
    }

    public String getChangeStreamOperation() {
        return this.getPathTokenAt(4);
    }

    public URI getUri() throws URISyntaxException {
        return new URI(Arrays.asList(this.pathTokens).stream().reduce("/", (t1, t2) -> t1 + "/" + t2));
    }

    public boolean isReservedResource() {
        if (this.getType() == ExchangeKeys.TYPE.ROOT) {
            return false;
        }
        return MongoRequest.isReservedDbName(this.getDBName()) || MongoRequest.isReservedCollectionName(this.getCollectionName()) || MongoRequest.isReservedDocumentId(this.getType(), this.getDocumentId());
    }

    public String getUriPrefix() {
        return this.whereUri;
    }

    public String getMappingUri() {
        return this.whatUri;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getPagesize() {
        return this.pagesize;
    }

    public void setPagesize(int pagesize) {
        this.pagesize = pagesize;
    }

    public ExchangeKeys.REPRESENTATION_FORMAT getRepresentationFormat() {
        return this.representationFormat;
    }

    public void setRepresentationFormat(ExchangeKeys.REPRESENTATION_FORMAT representationFormat) {
        this.representationFormat = representationFormat;
    }

    public boolean isCount() {
        return this.count || this.getType() == ExchangeKeys.TYPE.ROOT_SIZE || this.getType() == ExchangeKeys.TYPE.COLLECTION_SIZE || this.getType() == ExchangeKeys.TYPE.FILES_BUCKET_SIZE || this.getType() == ExchangeKeys.TYPE.SCHEMA_STORE_SIZE;
    }

    public void setCount(boolean count) {
        this.count = count;
    }

    public Deque<String> getFilter() {
        return this.filter;
    }

    public void setFilter(Deque<String> filter) {
        this.filter = filter;
    }

    public Deque<String> getHint() {
        return this.hint;
    }

    public void setHint(Deque<String> hint) {
        this.hint = hint;
    }

    public BsonDocument getFiltersDocument() throws JsonParseException {
        BsonDocument filterQuery = new BsonDocument();
        if (this.filter != null) {
            if (this.filter.size() > 1) {
                BsonArray _filters = new BsonArray();
                this.filter.stream().forEach(f -> _filters.add((BsonValue)BsonDocument.parse((String)f)));
                filterQuery.put("$and", (BsonValue)_filters);
            } else if (this.filter.size() == 1) {
                filterQuery.putAll((Map)BsonDocument.parse((String)this.filter.getFirst()));
            } else {
                return filterQuery;
            }
        }
        return filterQuery;
    }

    public BsonDocument getSortByDocument() throws JsonParseException {
        if (this.sortBy == null) {
            return BsonUtils.document().put("_id", -1).get();
        }
        BsonUtils.DocumentBuilder ret = BsonUtils.document();
        this.sortBy.stream().map(String::trim).forEach(s -> {
            try {
                BsonDocument _s = BsonDocument.parse((String)s);
                ret.putAll(_s.asDocument());
            }
            catch (JsonParseException e) {
                if (s.startsWith("{")) {
                    throw new JsonParseException("Invalid sort parameter", (Throwable)e);
                }
                if (s.startsWith("-")) {
                    ret.put(s.substring(1), -1);
                } else if (s.startsWith("+")) {
                    ret.put(s.substring(1), 1);
                } else {
                    ret.put((String)s, 1);
                }
            }
            catch (BsonInvalidOperationException biop) {
                throw new JsonParseException("Invalid sort parameter", (Throwable)biop);
            }
        });
        return ret.get();
    }

    public BsonDocument getHintDocument() throws JsonParseException {
        if (this.hint == null || this.hint.isEmpty()) {
            return null;
        }
        BsonDocument ret = new BsonDocument();
        this.hint.stream().forEach(s -> {
            String _s = s.strip();
            try {
                BsonDocument _hint = BsonDocument.parse((String)_s);
                ret.putAll((Map)_hint);
            }
            catch (JsonParseException e) {
                if (_s.startsWith("-")) {
                    ret.put(_s.substring(1), (BsonValue)new BsonInt32(-1));
                }
                if (_s.startsWith("+")) {
                    ret.put(_s.substring(1), (BsonValue)new BsonInt32(11));
                }
                ret.put(_s, (BsonValue)new BsonInt32(1));
            }
        });
        return ret;
    }

    public BsonDocument getProjectionDocument() throws JsonParseException {
        if (this.keys == null || this.keys.isEmpty()) {
            return null;
        }
        BsonDocument projection = new BsonDocument();
        this.keys.stream().forEach(f -> projection.putAll((Map)BsonDocument.parse((String)f)));
        return projection;
    }

    public BsonDocument getAggregationVars() {
        return this.aggregationVars;
    }

    public void setAggregationVars(BsonDocument aggregationVars) {
        this.aggregationVars = aggregationVars;
    }

    public Deque<String> getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(Deque<String> sortBy) {
        this.sortBy = sortBy;
    }

    public BsonDocument getCollectionProps() {
        return this.collectionProps;
    }

    public void setCollectionProps(BsonDocument collectionProps) {
        this.collectionProps = collectionProps;
    }

    public BsonDocument getDbProps() {
        return this.dbProps;
    }

    public void setDbProps(BsonDocument dbProps) {
        this.dbProps = dbProps;
    }

    public String getUnmappedRequestUri() {
        return this.unmappedUri;
    }

    public String getMappedRequestUri() {
        return this.mappedUri;
    }

    public Map<String, String> getPathTemplateParamenters() {
        if (this.pathTemplateMatch == null) {
            return null;
        }
        return this.pathTemplateMatch.getParameters();
    }

    private String getPathTokenAt(int index) {
        return this.pathTokens.length > index ? this.pathTokens[index] : null;
    }

    public boolean isCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public ExchangeKeys.DOC_ID_TYPE getDocIdType() {
        return this.docIdType;
    }

    public void setDocIdType(ExchangeKeys.DOC_ID_TYPE docIdType) {
        this.docIdType = docIdType;
    }

    public void setDocumentId(BsonValue documentId) {
        this.documentId = documentId;
    }

    public BsonValue getDocumentId() {
        if (this.isDbMeta()) {
            return new BsonString("_properties");
        }
        if (this.isCollectionMeta()) {
            return new BsonString("_properties.".concat(this.getPathTokenAt(2)));
        }
        return this.documentId;
    }

    public ClientSessionImpl getClientSession() {
        return this.clientSession;
    }

    public void setClientSession(ClientSessionImpl clientSession) {
        this.clientSession = clientSession;
    }

    public JsonMode getJsonMode() {
        return this.jsonMode;
    }

    public boolean isContentInjected() {
        return (Boolean)this.wrapped.getAttachment(CONTENT_INJECTED);
    }

    public final void setContentInjected(boolean value) {
        this.wrapped.putAttachment(CONTENT_INJECTED, (Object)value);
    }

    @Override
    public BsonValue getContent() {
        if (!this.isContentInjected()) {
            LOGGER.trace("getContent() called but content has not been injected yet. Let's inject it.");
            BsonValue attacheBsonContent = MongoServiceAttachments.attachedBsonContent(this.wrapped);
            if (attacheBsonContent == null) {
                MongoRequestContentInjector.inject(this.wrapped);
            } else {
                MongoRequest.of(this.wrapped).setContent(attacheBsonContent);
            }
        }
        return (BsonValue)super.getContent();
    }

    @Override
    public void setContent(BsonValue content) {
        super.setContent(content);
        this.setContentInjected(true);
    }

    public InputStream getFileInputStream() {
        if (!this.isContentInjected()) {
            LOGGER.debug("getFileInputStream() called but content has not been injected yet. Let's inject it.");
            MongoRequestContentInjector.inject(this.wrapped);
        }
        return this.fileInputStream;
    }

    public void setFileInputStream(InputStream fileInputStream) {
        this.fileInputStream = fileInputStream;
        this.setContentInjected(true);
    }

    public Deque<String> getKeys() {
        return this.keys;
    }

    public void setKeys(Deque<String> keys) {
        this.keys = keys;
    }

    public ExchangeKeys.HAL_MODE getHalMode() {
        return this.halMode;
    }

    public boolean isFullHalMode() {
        return this.halMode == ExchangeKeys.HAL_MODE.FULL || this.halMode == ExchangeKeys.HAL_MODE.F;
    }

    public void setHalMode(ExchangeKeys.HAL_MODE halMode) {
        this.halMode = halMode;
    }

    public boolean isDbNameInvalid() {
        return this.isDbNameInvalid(this.getDBName());
    }

    public long getRequestStartTime() {
        return this.requestStartTime;
    }

    public boolean isDbNameInvalid(String dbName) {
        return dbName == null || dbName.contains(ExchangeKeys.NUL) || dbName.contains(" ") || dbName.contains("/") || dbName.contains("\\") || dbName.contains(".") || dbName.contains("\"") || dbName.contains("$") || dbName.length() > 64 || dbName.length() == 0;
    }

    public boolean isDbNameInvalidOnWindows() {
        return this.isDbNameInvalidOnWindows(this.getDBName());
    }

    public boolean isDbNameInvalidOnWindows(String dbName) {
        return this.isDbNameInvalid() || dbName.contains("*") || dbName.contains("<") || dbName.contains(">") || dbName.contains(":") || dbName.contains(".") || dbName.contains("|") || dbName.contains("?");
    }

    public boolean isCollectionNameInvalid() {
        return this.isCollectionNameInvalid(this.getCollectionName());
    }

    public boolean isCollectionNameInvalid(String collectionName) {
        return collectionName == null || collectionName.contains(ExchangeKeys.NUL) || collectionName.contains("$") || collectionName.length() == 64;
    }

    public String getETag() {
        return this.etag;
    }

    public BsonDocument getShardKey() {
        return this.shardKey;
    }

    public void setShardKey(BsonDocument shardKey) {
        this.shardKey = shardKey;
    }

    public boolean isNoProps() {
        return this.noProps;
    }

    public void setNoProps(boolean noProps) {
        this.noProps = noProps;
    }

    public boolean isAggregation() {
        return this.getType() == ExchangeKeys.TYPE.AGGREGATION;
    }

    public boolean isBulkDocuments() {
        return this.getType() == ExchangeKeys.TYPE.BULK_DOCUMENTS;
    }

    public boolean isCollection() {
        return this.getType() == ExchangeKeys.TYPE.COLLECTION;
    }

    public boolean isCollectionIndexes() {
        return this.getType() == ExchangeKeys.TYPE.COLLECTION_INDEXES;
    }

    public boolean isDb() {
        return this.getType() == ExchangeKeys.TYPE.DB;
    }

    public boolean isDocument() {
        return this.getType() == ExchangeKeys.TYPE.DOCUMENT;
    }

    public boolean isFile() {
        return this.getType() == ExchangeKeys.TYPE.FILE;
    }

    public boolean isFilesBucket() {
        return this.getType() == ExchangeKeys.TYPE.FILES_BUCKET;
    }

    public boolean isFileBinary() {
        return this.getType() == ExchangeKeys.TYPE.FILE_BINARY;
    }

    public boolean isIndex() {
        return this.getType() == ExchangeKeys.TYPE.INDEX;
    }

    public boolean isRoot() {
        return this.getType() == ExchangeKeys.TYPE.ROOT;
    }

    public boolean isSessions() {
        return this.getType() == ExchangeKeys.TYPE.SESSIONS;
    }

    public boolean isSession() {
        return this.getType() == ExchangeKeys.TYPE.SESSION;
    }

    public boolean isTxns() {
        return this.getType() == ExchangeKeys.TYPE.TRANSACTIONS;
    }

    public boolean isTxn() {
        return this.getType() == ExchangeKeys.TYPE.TRANSACTION;
    }

    public boolean isSchema() {
        return this.getType() == ExchangeKeys.TYPE.SCHEMA;
    }

    public boolean isSchemaStore() {
        return this.getType() == ExchangeKeys.TYPE.SCHEMA_STORE;
    }

    @Deprecated
    public boolean isMetrics() {
        return this.getType() == ExchangeKeys.TYPE.METRICS;
    }

    public boolean isRootSize() {
        return this.getType() == ExchangeKeys.TYPE.ROOT_SIZE;
    }

    public boolean isDbSize() {
        return this.getType() == ExchangeKeys.TYPE.DB_SIZE;
    }

    public boolean isDbMeta() {
        return this.getType() == ExchangeKeys.TYPE.DB_META;
    }

    public boolean isCollectionSize() {
        return this.getType() == ExchangeKeys.TYPE.COLLECTION_SIZE;
    }

    public boolean isCollectionMeta() {
        return this.getType() == ExchangeKeys.TYPE.COLLECTION_META;
    }

    public boolean isFilesBucketSize() {
        return this.getType() == ExchangeKeys.TYPE.FILES_BUCKET_SIZE;
    }

    public boolean isFilesBucketMeta() {
        return this.getType() == ExchangeKeys.TYPE.FILES_BUCKET_META;
    }

    public boolean isSchemaStoreSize() {
        return this.getType() == ExchangeKeys.TYPE.SCHEMA_STORE_SIZE;
    }

    public boolean isSchemaStoreMeta() {
        return this.getType() == ExchangeKeys.TYPE.SCHEMA_STORE_META;
    }

    public boolean isWriteDocument() {
        return (this.isPut() || this.isPatch()) && (this.isFile() || this.isDocument() || this.isSchema()) || this.isPost() && (this.isCollection() || this.isFilesBucket() || this.isSchemaStore());
    }

    public boolean isETagCheckRequired() {
        return this.etagCheckRequired;
    }

    public void setETagCheckRequired(boolean etagCheckRequired) {
        this.etagCheckRequired = etagCheckRequired;
    }

    public ExchangeKeys.WRITE_MODE getWriteMode() {
        return this.writeMode;
    }

    public void setWriteMode(ExchangeKeys.WRITE_MODE writeMode) {
        this.writeMode = writeMode;
    }

    public boolean isForceEtagCheck() {
        return this.forceEtagCheck;
    }

    public boolean isNoCache() {
        return this.noCache;
    }

    public Optional<RSOps> rsOps() {
        return this.rsOps;
    }
}

