/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.exchange;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Deque;
import java.util.Iterator;
import java.util.stream.StreamSupport;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonNull;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.json.JsonParseException;
import org.restheart.exchange.ByteArrayProxyRequest;
import org.restheart.exchange.MongoRequest;
import org.restheart.exchange.MongoResponse;
import org.restheart.utils.BsonUtils;
import org.restheart.utils.ChannelReader;
import org.restheart.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoRequestContentInjector {
    static final Logger LOGGER = LoggerFactory.getLogger(MongoRequestContentInjector.class);
    private static final String ERROR_INVALID_CONTENTTYPE = "Content-Type must be either: application/json or application/hal+json";
    private static final FormParserFactory FORM_PARSER = FormParserFactory.builder().withDefaultCharset(StandardCharsets.UTF_8.name()).build();

    private static boolean isHalOrJson(HeaderValues contentTypes) {
        return contentTypes == null || contentTypes.isEmpty() || contentTypes.stream().anyMatch(ct -> ct.startsWith("application/hal+json") || ct.startsWith("application/json"));
    }

    private static boolean isFormOrMultipart(HeaderValues contentTypes) {
        return contentTypes != null && !contentTypes.isEmpty() && contentTypes.stream().anyMatch(ct -> ct.startsWith("application/x-www-form-urlencoded") || ct.startsWith("multipart/form-data"));
    }

    public static String checkReservedId(BsonValue content) {
        if (content == null) {
            return null;
        }
        if (content.isDocument()) {
            BsonValue id = content.asDocument().get((Object)"_id");
            if (id == null || !id.isString()) {
                return null;
            }
            String _id = id.asString().getValue();
            if ("_MaxKey".equalsIgnoreCase(_id) || "_MinKey".equalsIgnoreCase(_id) || "_null".equalsIgnoreCase(_id) || "_true".equalsIgnoreCase(_id) || "_false".equalsIgnoreCase(_id)) {
                return _id;
            }
            return null;
        }
        if (content.isArray()) {
            BsonArray arrayContent = content.asArray();
            Iterator objs = arrayContent.getValues().iterator();
            String ret = null;
            while (objs.hasNext()) {
                BsonValue obj = (BsonValue)objs.next();
                if (obj.isDocument()) {
                    ret = MongoRequestContentInjector.checkReservedId(obj);
                    if (ret == null) continue;
                    break;
                }
                LOGGER.warn("element of content array is not an object");
            }
            return ret;
        }
        LOGGER.warn("content is not an object nor an array");
        return null;
    }

    protected static BsonDocument extractMetadata(FormData formData) throws JsonParseException {
        String metadataString;
        String string = formData.getFirst("metadata") != null ? formData.getFirst("metadata").getValue() : (metadataString = formData.getFirst("properties") != null ? formData.getFirst("properties").getValue() : null);
        if (metadataString != null) {
            BsonValue parsed = BsonUtils.parse(metadataString);
            if (parsed == null) {
                return new BsonDocument();
            }
            if (parsed.isDocument()) {
                return parsed.asDocument();
            }
            throw new JsonParseException("metadata is not a valid JSON object");
        }
        return new BsonDocument();
    }

    private static String extractFileField(FormData formData) {
        String fileField = null;
        for (String f : formData) {
            if (formData.getFirst(f) == null || !formData.getFirst(f).isFileItem()) continue;
            fileField = f;
            break;
        }
        return fileField;
    }

    public static void inject(HttpServerExchange exchange) {
        BsonDocument _content;
        BsonValue _id;
        BsonValue content;
        MongoRequest request = MongoRequest.of(exchange);
        MongoResponse response = MongoResponse.of(exchange);
        if (request.isGet() || request.isOptions() || request.isDelete()) {
            return;
        }
        HeaderValues contentType = request.getHeaders().get(Headers.CONTENT_TYPE);
        if (contentType == null) {
            content = null;
        } else if (MongoRequestContentInjector.isFormOrMultipart(contentType)) {
            content = MongoRequestContentInjector.injectMultipart(exchange, request, response);
        } else if (MongoRequestContentInjector.isHalOrJson(contentType)) {
            content = MongoRequestContentInjector.injectBson(exchange);
        } else {
            response.setInError(415, ERROR_INVALID_CONTENTTYPE);
            return;
        }
        if (content == null) {
            content = new BsonDocument();
        } else if (content.isArray()) {
            if (!(request.isCollection() && request.isPost() || request.isDocument() && request.isPatch())) {
                response.setInError(406, "request content must be a Json object");
                return;
            }
            if (!content.asArray().stream().anyMatch(_doc -> {
                if (_doc.isDocument()) {
                    BsonValue _id = _doc.asDocument().get((Object)"_id");
                    if (_id != null && _id.isArray()) {
                        response.setInError(406, "the type of _id in request data is not supported: " + (_id == null ? "" : _id.getBsonType().name()));
                        return false;
                    }
                    return true;
                }
                response.setInError(406, "request data must be either an json object or an array of objects");
                return false;
            })) {
                return;
            }
        } else if (content.isDocument() && (_id = (_content = content.asDocument()).get((Object)"_id")) != null && _id.isArray()) {
            response.setInError(406, "the type of _id in request data is not supported: " + _id.getBsonType().name());
            return;
        }
        if (request.isPost() || request.isPut()) {
            if (BsonUtils.containsUpdateOperators(content, true)) {
                response.setInError(400, "update operators (but $currentDate) cannot be used on POST and PUT requests");
                return;
            }
            content = BsonUtils.unflatten(content);
        }
        request.setContent(content);
    }

    private static BsonValue injectBson(HttpServerExchange exchange) {
        BsonValue content;
        block6: {
            String contentString;
            ByteArrayProxyRequest bar = ByteArrayProxyRequest.of(exchange);
            try {
                contentString = bar.isContentAvailable() ? new String(bar.readContent(), StandardCharsets.UTF_8) : ChannelReader.readString(exchange);
            }
            catch (IOException ieo) {
                String errMsg = "Error reading request content";
                LOGGER.error(errMsg, (Throwable)ieo);
                MongoResponse.of(exchange).setInError(406, errMsg);
                return null;
            }
            if (contentString != null && !contentString.isEmpty()) {
                try {
                    content = BsonUtils.parse(contentString);
                    if (content != null && !content.isDocument() && !content.isArray()) {
                        throw new IllegalArgumentException("request data must be either a json object or an array, got " + content.getBsonType().name());
                    }
                    break block6;
                }
                catch (IllegalArgumentException | JsonParseException ex) {
                    MongoResponse.of(exchange).setInError(406, "Invalid JSON. " + ex.getMessage(), ex);
                    return null;
                }
            }
            content = null;
        }
        return content;
    }

    private static BsonValue injectMultipart(HttpServerExchange exchange, MongoRequest request, MongoResponse response) {
        FormData formData;
        if (request.isWriteDocument() && (request.isFile() || request.isFilesBucket())) {
            return MongoRequestContentInjector.injectMultiparForFiles(exchange, request, response);
        }
        FormDataParser parser = FORM_PARSER.createParser(exchange);
        if (parser == null) {
            response.setInError(406, "There is no form parser registered for the request content type");
            return null;
        }
        try {
            formData = parser.parseBlocking();
        }
        catch (IOException ioe) {
            response.setInError(406, "Error parsing the multipart form: data could not be read", ioe);
            return null;
        }
        BsonDocument ret = new BsonDocument();
        boolean[] errored = new boolean[]{false};
        StreamSupport.stream(formData.spliterator(), false).map(partName -> new Pair<String, Deque>((String)partName, formData.get(partName))).filter(part -> !((Deque)part.getValue()).isEmpty()).map(part -> new Pair<String, FormData.FormValue>((String)part.getKey(), (FormData.FormValue)((Deque)part.getValue()).getFirst())).filter(part -> !((FormData.FormValue)part.getValue()).isFileItem()).forEach(part -> {
            try {
                String value = ((FormData.FormValue)part.getValue()).getValue();
                if (value == null) {
                    ret.put((String)part.getKey(), (BsonValue)BsonNull.VALUE);
                } else if (value.isBlank()) {
                    ret.put((String)part.getKey(), (BsonValue)new BsonString(value));
                } else {
                    ret.put((String)part.getKey(), BsonUtils.parse(((FormData.FormValue)part.getValue()).getValue()));
                }
            }
            catch (JsonParseException jpe) {
                String strippedValue = ((FormData.FormValue)part.getValue()).getValue().strip();
                if (strippedValue.startsWith("{") || strippedValue.startsWith("[")) {
                    response.setInError(406, "Invalid JSON. " + jpe.getMessage(), jpe);
                    errored[0] = true;
                }
                ret.put((String)part.getKey(), (BsonValue)new BsonString(((FormData.FormValue)part.getValue()).getValue()));
            }
        });
        return errored[0] ? null : ret;
    }

    private static BsonValue injectMultiparForFiles(HttpServerExchange exchange, MongoRequest request, MongoResponse response) {
        BsonDocument content;
        FormData formData;
        FormDataParser parser = FORM_PARSER.createParser(exchange);
        if (parser == null) {
            response.setInError(406, "There is no form parser registered for the request content type");
            return null;
        }
        try {
            formData = parser.parseBlocking();
        }
        catch (IOException ioe) {
            response.setInError(406, "Error parsing the multipart form: data could not be read", ioe);
            return null;
        }
        try {
            content = MongoRequestContentInjector.extractMetadata(formData);
        }
        catch (IllegalArgumentException | JsonParseException ex) {
            response.setInError(406, "Invalid data: 'metadata' field is not a valid JSON object", ex);
            return null;
        }
        String fileField = MongoRequestContentInjector.extractFileField(formData);
        if (fileField == null) {
            response.setInError(406, "This request does not contain any binary file");
            return null;
        }
        try {
            InputStream fileInputStream = formData.getFirst(fileField).getFileItem().getInputStream();
            request.setFileInputStream(fileInputStream);
        }
        catch (IOException ioe) {
            response.addWarning("error getting binary field from request");
            LOGGER.warn("error getting binary field from request", (Throwable)ioe);
            return null;
        }
        return content;
    }
}

