/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.exchange;

import com.mongodb.MongoCommandException;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.result.UpdateResult;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.bson.json.JsonParseException;
import org.restheart.exchange.BsonResponse;
import org.restheart.exchange.MongoRequest;
import org.restheart.exchange.Request;
import org.restheart.mongodb.db.OperationResult;
import org.restheart.utils.BsonUtils;
import org.restheart.utils.HttpStatus;

public class MongoResponse
extends BsonResponse {
    private static final ReplaceOptions R_NOT_UPSERT_OPS = new ReplaceOptions().upsert(false);
    private OperationResult dbOperationResult;
    private final List<String> warnings = new ArrayList<String>();
    private long count = -1L;

    protected MongoResponse(HttpServerExchange exchange) {
        super(exchange);
    }

    public static MongoResponse init(HttpServerExchange exchange) {
        return new MongoResponse(exchange);
    }

    public static MongoResponse of(HttpServerExchange exchange) {
        return MongoResponse.of(exchange, MongoResponse.class);
    }

    @Override
    public String readContent() {
        Request request = Request.of(this.wrapped);
        Object tosend = !request.isGet() && (this.content == null || ((BsonValue)this.content).isDocument()) ? this.addWarnings(this.content == null ? null : ((BsonValue)this.content).asDocument()) : (BsonValue)this.content;
        if (tosend != null) {
            if (request instanceof MongoRequest) {
                return BsonUtils.toJson(tosend, ((MongoRequest)request).getJsonMode());
            }
            return BsonUtils.toJson(tosend);
        }
        return null;
    }

    private BsonDocument addWarnings(BsonDocument content) {
        if (content != null) {
            if (this.warnings != null && !this.warnings.isEmpty() && content.isDocument()) {
                BsonDocument contentWithWarnings = new BsonDocument();
                BsonArray ws = new BsonArray();
                this.warnings.stream().map(w -> new BsonString(w)).forEachOrdered(arg_0 -> ((BsonArray)ws).add(arg_0));
                contentWithWarnings.put("_warnings", (BsonValue)ws);
                contentWithWarnings.putAll((Map)content.asDocument());
                return contentWithWarnings;
            }
            return content;
        }
        if (this.warnings != null && !this.warnings.isEmpty()) {
            BsonDocument contentWithWarnings = new BsonDocument();
            BsonArray ws = new BsonArray();
            this.warnings.stream().map(w -> new BsonString(w)).forEachOrdered(arg_0 -> ((BsonArray)ws).add(arg_0));
            contentWithWarnings.put("_warnings", (BsonValue)ws);
            return contentWithWarnings;
        }
        return content;
    }

    public OperationResult getDbOperationResult() {
        return this.dbOperationResult;
    }

    public void setDbOperationResult(OperationResult dbOperationResult) {
        this.dbOperationResult = dbOperationResult;
    }

    public List<String> getWarnings() {
        return Collections.unmodifiableList(this.warnings);
    }

    public void addWarning(String warning) {
        this.warnings.add(warning);
    }

    @Override
    public void setInError(int code, String message, Throwable t) {
        this.setStatusCode(code);
        this.setInError(true);
        this.setContent(this.getErrorContent(code, HttpStatus.getStatusText(code), message, t, false));
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    private BsonDocument getErrorContent(int code, String httpStatusText, String message, Throwable t, boolean includeStackTrace) {
        BsonDocument rep = new BsonDocument();
        rep.put("http status code", (BsonValue)new BsonInt32(code));
        rep.put("http status description", (BsonValue)new BsonString(httpStatusText));
        if (message != null) {
            rep.put("message", (BsonValue)new BsonString(this.avoidEscapedChars(message)));
        }
        if (t != null) {
            BsonArray stackTrace;
            rep.put("exception", (BsonValue)new BsonString(t.getClass().getName()));
            if (t.getMessage() != null) {
                if (t instanceof JsonParseException) {
                    rep.put("exception message", (BsonValue)new BsonString("invalid json"));
                } else if (t instanceof MongoCommandException) {
                    MongoCommandException mce = (MongoCommandException)t;
                    BsonUtils.DocumentBuilder errorDoc = BsonUtils.document().put("code", mce.getResponse().get((Object)"code")).put("codeName", mce.getResponse().get((Object)"codeName"));
                    BsonValue errmsg = mce.getResponse().get((Object)"errmsg");
                    if (errmsg != null && errmsg.isString()) {
                        String _errmsg = errmsg.asString().getValue();
                        _errmsg = _errmsg.length() <= 100 ? _errmsg : _errmsg.substring(0, 100) + "...";
                        errorDoc.put("errmsg", _errmsg);
                    }
                    rep.put("exception message", (BsonValue)errorDoc.get());
                } else {
                    rep.put("exception message", (BsonValue)new BsonString(this.avoidEscapedChars(t.getMessage())));
                }
            }
            if (includeStackTrace && (stackTrace = this.getStackTrace(t)) != null) {
                rep.put("stack trace", (BsonValue)stackTrace);
            }
        }
        BsonArray _warnings = new BsonArray();
        if (this.getWarnings() != null && !this.getWarnings().isEmpty()) {
            this.getWarnings().forEach(w -> _warnings.add((BsonValue)new BsonString(w)));
            rep.put("_warnings", (BsonValue)_warnings);
        }
        return rep;
    }

    private BsonArray getStackTrace(Throwable t) {
        if (t == null || t.getStackTrace() == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        String st = sw.toString();
        st = this.avoidEscapedChars(st);
        String[] lines = st.split("\n");
        BsonArray list = new BsonArray();
        for (String line : lines) {
            list.add((BsonValue)new BsonString(line));
        }
        return list;
    }

    private String avoidEscapedChars(String s) {
        return s == null ? null : s.replaceAll("\"", "'").replaceAll("\t", "  ");
    }

    public void rollback(MongoClient mclient) throws Exception {
        MongoRequest request = MongoRequest.of(this.getExchange());
        MongoResponse response = MongoResponse.of(this.getExchange());
        if (request.isBulkDocuments() || request.isPost() && request.getContent() != null && request.getContent().isArray()) {
            throw new UnsupportedOperationException("rollback() does not support bulk updates");
        }
        MongoDatabase mdb = mclient.getDatabase(request.getDBName());
        MongoCollection coll = mdb.getCollection(request.getCollectionName(), BsonDocument.class);
        BsonDocument oldData = this.getDbOperationResult().getOldData();
        Object newEtag = this.getDbOperationResult().getEtag();
        if (oldData != null) {
            MongoResponse.restoreDocument(request.getClientSession(), (MongoCollection<BsonDocument>)coll, oldData.get((Object)"_id"), request.getShardKey(), oldData, newEtag, "_etag");
            if (oldData.get((Object)"$set") != null && oldData.get((Object)"$set").isDocument() && oldData.get((Object)"$set").asDocument().get((Object)"_etag") != null) {
                response.getHeaders().put(Headers.ETAG, oldData.get((Object)"$set").asDocument().get((Object)"_etag").asObjectId().getValue().toString());
            } else {
                response.getHeaders().remove(Headers.ETAG);
            }
        } else {
            BsonValue newId = this.getDbOperationResult().getNewData().get((Object)"_id");
            coll.deleteOne(Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)newId), Filters.eq((String)"_etag", (Object)newEtag)}));
            response.getHeaders().remove(Headers.LOCATION);
            response.getHeaders().remove(Headers.ETAG);
        }
    }

    private static boolean restoreDocument(ClientSession cs, MongoCollection<BsonDocument> coll, Object documentId, BsonDocument shardKeys, BsonDocument data, Object etag, String etagLocation) {
        Objects.requireNonNull(coll);
        Objects.requireNonNull(documentId);
        Objects.requireNonNull(data);
        Bson query = etag == null ? Filters.eq((String)"_id", (Object)documentId) : Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)documentId), Filters.eq((String)(etagLocation != null && !etagLocation.isEmpty() ? etagLocation : "_etag"), (Object)etag)});
        if (shardKeys != null) {
            query = Filters.and((Bson[])new Bson[]{query, shardKeys});
        }
        UpdateResult result = cs == null ? coll.replaceOne(query, (Object)data, R_NOT_UPSERT_OPS) : coll.replaceOne(cs, query, (Object)data, R_NOT_UPSERT_OPS);
        return result.getModifiedCount() == 1L;
    }
}

