/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.exchange;

import java.util.Objects;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.utils.URLUtils;

public class PipelineInfo {
    private final PIPELINE_TYPE type;
    private final String uri;
    private final RegisterPlugin.MATCH_POLICY matchPolicy;
    private final String name;

    public PipelineInfo(PIPELINE_TYPE type, String uri, RegisterPlugin.MATCH_POLICY matchPolicy, String name) {
        Objects.requireNonNull(type, "argument 'type' cannot be null");
        Objects.requireNonNull(uri, "argument 'uri' cannot be null");
        this.type = type;
        this.uri = URLUtils.removeTrailingSlashes(uri);
        this.matchPolicy = matchPolicy;
        this.name = name;
    }

    public PipelineInfo(PIPELINE_TYPE type, String uri, String name) {
        Objects.requireNonNull(type, "argument 'type' cannot be null");
        Objects.requireNonNull(uri, "argument 'uri' cannot be null");
        this.type = type;
        this.uri = URLUtils.removeTrailingSlashes(uri);
        this.matchPolicy = RegisterPlugin.MATCH_POLICY.PREFIX;
        this.name = name;
    }

    public String toString() {
        return "PipelineInfo(type: " + this.getType() + ", uri: " + this.getUri() + ", matchPolicy: " + this.getUriMatchPolicy() + ", name: " + this.getName() + ")";
    }

    public PIPELINE_TYPE getType() {
        return this.type;
    }

    public String getUri() {
        return this.uri;
    }

    public RegisterPlugin.MATCH_POLICY getUriMatchPolicy() {
        return this.matchPolicy;
    }

    public String getName() {
        return this.name;
    }

    public static enum PIPELINE_TYPE {
        SERVICE,
        PROXY,
        STATIC_RESOURCE;

    }
}

