/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.exchange;

import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import java.io.IOException;
import java.lang.reflect.Field;
import org.restheart.exchange.BufferedExchange;
import org.restheart.exchange.Request;

public abstract class ProxyRequest<T>
extends Request<T>
implements BufferedExchange<T>,
AutoCloseable {
    public ProxyRequest(HttpServerExchange exchange) {
        super(exchange);
    }

    @Override
    public abstract T readContent() throws IOException;

    @Override
    public abstract void writeContent(T var1) throws IOException;

    protected AttachmentKey<PooledByteBuffer[]> getRawContentKey() {
        Field f;
        try {
            f = HttpServerExchange.class.getDeclaredField("BUFFERED_REQUEST_DATA");
            f.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException ex) {
            throw new RuntimeException("could not find BUFFERED_REQUEST_DATA field", ex);
        }
        try {
            return (AttachmentKey)f.get(this.getWrappedExchange());
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new RuntimeException("could not access BUFFERED_REQUEST_DATA field", ex);
        }
    }

    @Override
    public void setBuffer(PooledByteBuffer[] raw) {
        PooledByteBuffer[] oldBuffers = (PooledByteBuffer[])this.getWrappedExchange().getAttachment(this.getRawContentKey());
        if (oldBuffers != null) {
            for (PooledByteBuffer oldBuffer : oldBuffers) {
                if (oldBuffer == null) continue;
                oldBuffer.close();
            }
        }
        this.getWrappedExchange().putAttachment(this.getRawContentKey(), (Object)raw);
    }

    @Override
    public PooledByteBuffer[] getBuffer() {
        if (!this.isContentAvailable()) {
            throw new IllegalStateException("Request content is not available. Add a Request Inteceptor with @RegisterPlugin(requiresContent = true) to make the content available.");
        }
        return (PooledByteBuffer[])this.getWrappedExchange().getAttachment(this.getRawContentKey());
    }

    @Override
    public boolean isContentAvailable() {
        return null != this.getWrappedExchange().getAttachment(this.getRawContentKey());
    }

    @Override
    public void close() {
        if (this.isContentAvailable()) {
            for (PooledByteBuffer b : this.getBuffer()) {
                if (b == null) continue;
                b.close();
            }
            this.setBuffer(null);
        }
    }
}

