/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.exchange;

import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;
import java.io.IOException;
import org.restheart.exchange.BufferedExchange;
import org.restheart.exchange.Response;
import org.restheart.utils.HttpStatus;

public abstract class ProxyResponse<T>
extends Response<T>
implements BufferedExchange<T>,
AutoCloseable {
    public static final AttachmentKey<PooledByteBuffer[]> BUFFERED_RESPONSE_DATA_KEY = AttachmentKey.create(PooledByteBuffer[].class);

    protected ProxyResponse(HttpServerExchange exchange) {
        super(exchange);
    }

    @Override
    public abstract T readContent() throws IOException;

    @Override
    public abstract void writeContent(T var1) throws IOException;

    public AttachmentKey<PooledByteBuffer[]> getRawContentKey() {
        return BUFFERED_RESPONSE_DATA_KEY;
    }

    @Override
    public PooledByteBuffer[] getBuffer() {
        if (!this.isContentAvailable()) {
            throw new IllegalStateException("Response content is not available. Add a Response Inteceptor with @RegisterPlugin(requiresContent = true) to make the content available.");
        }
        return (PooledByteBuffer[])this.getWrappedExchange().getAttachment(this.getRawContentKey());
    }

    @Override
    public void setBuffer(PooledByteBuffer[] raw) {
        PooledByteBuffer[] oldBuffers = (PooledByteBuffer[])this.getWrappedExchange().getAttachment(BUFFERED_RESPONSE_DATA_KEY);
        if (oldBuffers != null) {
            for (PooledByteBuffer oldBuffer : oldBuffers) {
                if (oldBuffer == null) continue;
                oldBuffer.close();
            }
        }
        this.getWrappedExchange().putAttachment(this.getRawContentKey(), (Object)raw);
    }

    @Override
    public boolean isContentAvailable() {
        return null != this.getWrappedExchange().getAttachment(this.getRawContentKey());
    }

    protected void setContentLength(int length) {
        this.getHeaders().put(Headers.CONTENT_LENGTH, (long)length);
    }

    @Override
    public void setInError(int code, String message, Throwable t) {
        this.setStatusCode(code);
        this.setContentTypeAsJson();
        this.setInError(true);
        try {
            this.writeContent(this.getErrorContent(code, HttpStatus.getStatusText(code), message, t, false));
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    protected abstract T getErrorContent(int var1, String var2, String var3, Throwable var4, boolean var5) throws IOException;

    @Override
    public void close() {
        if (this.isContentAvailable()) {
            for (PooledByteBuffer b : this.getBuffer()) {
                if (b == null) continue;
                b.close();
            }
            this.setBuffer(null);
        }
    }
}

