/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.exchange;

import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import io.undertow.util.PathTemplate;
import io.undertow.util.PathTemplateMatcher;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.restheart.exchange.ByteArrayProxyRequest;
import org.restheart.exchange.Exchange;
import org.restheart.exchange.ExchangeKeys;
import org.restheart.exchange.PipelineInfo;
import org.restheart.exchange.ServiceRequest;

public abstract class Request<T>
extends Exchange<T> {
    public static final String SLASH = "/";
    public static final String PATCH = "PATCH";
    public static final String UNDERSCORE = "_";
    public static final AttachmentKey<PipelineInfo> PIPELINE_INFO_KEY = AttachmentKey.create(PipelineInfo.class);
    private static final AttachmentKey<Long> START_TIME_KEY = AttachmentKey.create(Long.class);
    private static final AttachmentKey<Map<String, List<String>>> XFORWARDED_HEADERS = AttachmentKey.create(Map.class);
    private static final AttachmentKey<Boolean> BLOCK_AUTH_FOR_TOO_MANY_REQUESTS = AttachmentKey.create(Boolean.class);

    protected Request(HttpServerExchange exchange) {
        super(exchange);
    }

    public static Request of(HttpServerExchange exchange) {
        PipelineInfo pi = Request.pipelineInfo(exchange);
        if (pi.getType() == PipelineInfo.PIPELINE_TYPE.SERVICE) {
            return ServiceRequest.of(exchange);
        }
        return ByteArrayProxyRequest.of(exchange);
    }

    public static String getContentType(HttpServerExchange exchange) {
        return exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
    }

    public String getPath() {
        return this.wrapped.getRequestPath();
    }

    public String getURL() {
        return this.wrapped.getRequestURL();
    }

    public String getQueryString() {
        return this.wrapped.getQueryString();
    }

    public ExchangeKeys.METHOD getMethod() {
        return Request.selectMethod(this.getWrappedExchange().getRequestMethod());
    }

    public long getRequestContentLength() {
        return this.wrapped.getRequestContentLength();
    }

    public Map<String, Deque<String>> getQueryParameters() {
        return this.wrapped.getQueryParameters();
    }

    @Deprecated
    public String getQueryParameterOfDefault(String name, String defaultValue) {
        return this.wrapped.getQueryParameters().containsKey(name) ? (String)((Deque)this.wrapped.getQueryParameters().get(name)).getFirst() : defaultValue;
    }

    public String getQueryParameterOrDefault(String name, String defaultValue) {
        return this.wrapped.getQueryParameters().containsKey(name) ? (String)((Deque)this.wrapped.getQueryParameters().get(name)).getFirst() : defaultValue;
    }

    public HeaderMap getHeaders() {
        return this.wrapped.getRequestHeaders();
    }

    public String getHeader(String name) {
        return this.getHeaders().getFirst(HttpString.tryFromString((String)name));
    }

    public void setHeader(HttpString name, String value) {
        if (this.getHeaders().get(name) == null) {
            this.getHeaders().put(name, value);
        } else {
            this.getHeaders().get(name).clear();
            this.getHeaders().get(name).add(value);
        }
    }

    public void setHeader(String name, String value) {
        if (this.getHeaders().get(name) == null) {
            this.getHeaders().put(HttpString.tryFromString((String)name), value);
        } else {
            this.getHeaders().get(HttpString.tryFromString((String)name)).clear();
            this.getHeaders().get(HttpString.tryFromString((String)name)).add(value);
        }
    }

    public Cookie getCookie(String name) {
        return this.wrapped.getRequestCookie(name);
    }

    public Map<String, String> getPathParams(String pathTemplate) {
        PathTemplateMatcher ptm = new PathTemplateMatcher();
        try {
            ptm.add(PathTemplate.create((String)pathTemplate), (Object)"");
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("wrong path template", t);
        }
        PathTemplateMatcher.PathMatchResult match = ptm.match(this.getPath());
        return match != null ? ptm.match(this.getPath()).getParameters() : new HashMap<String, String>();
    }

    public String getPathParam(String pathTemplate, String paramName) {
        Map<String, String> params = this.getPathParams(pathTemplate);
        return params != null ? params.get(paramName) : null;
    }

    @Override
    public String getContentType() {
        return Request.getContentType(this.getWrappedExchange());
    }

    public void setContentType(String responseContentType) {
        this.getHeaders().put(Headers.CONTENT_TYPE, responseContentType);
    }

    public void setContentTypeAsJson() {
        this.setContentType("application/json");
    }

    protected void setContentLength(int length) {
        this.getHeaders().put(Headers.CONTENT_LENGTH, (long)length);
    }

    public Long getStartTime() {
        return (Long)this.getWrappedExchange().getAttachment(START_TIME_KEY);
    }

    public void setStartTime(Long requestStartTime) {
        this.getWrappedExchange().putAttachment(START_TIME_KEY, (Object)requestStartTime);
    }

    public Account getAuthenticatedAccount() {
        return this.getWrappedExchange().getSecurityContext() != null ? this.getWrappedExchange().getSecurityContext().getAuthenticatedAccount() : null;
    }

    @Override
    public boolean isAuthenticated() {
        return this.getAuthenticatedAccount() != null;
    }

    public void addXForwardedHeader(String key, String value) {
        ArrayList<String> values;
        if (this.wrapped.getAttachment(XFORWARDED_HEADERS) == null) {
            this.wrapped.putAttachment(XFORWARDED_HEADERS, new LinkedHashMap());
        }
        if ((values = (ArrayList<String>)((Map)this.wrapped.getAttachment(XFORWARDED_HEADERS)).get(key)) == null) {
            values = new ArrayList<String>();
            ((Map)this.wrapped.getAttachment(XFORWARDED_HEADERS)).put(key, values);
        }
        values.add(value);
    }

    public Map<String, List<String>> getXForwardedHeaders() {
        return (Map)this.getWrappedExchange().getAttachment(XFORWARDED_HEADERS);
    }

    public static PipelineInfo pipelineInfo(HttpServerExchange exchange) {
        return (PipelineInfo)exchange.getAttachment(PIPELINE_INFO_KEY);
    }

    public static void setPipelineInfo(HttpServerExchange exchange, PipelineInfo pipelineInfo) {
        exchange.putAttachment(PIPELINE_INFO_KEY, (Object)pipelineInfo);
    }

    public PipelineInfo getPipelineInfo() {
        return (PipelineInfo)this.getWrappedExchange().getAttachment(PIPELINE_INFO_KEY);
    }

    public static PipelineInfo getPipelineInfo(HttpServerExchange exchange) {
        return (PipelineInfo)exchange.getAttachment(PIPELINE_INFO_KEY);
    }

    public void setPipelineInfo(PipelineInfo pipelineInfo) {
        this.getWrappedExchange().putAttachment(PIPELINE_INFO_KEY, (Object)pipelineInfo);
    }

    public boolean isDelete() {
        return this.getMethod() == ExchangeKeys.METHOD.DELETE;
    }

    public boolean isGet() {
        return this.getMethod() == ExchangeKeys.METHOD.GET;
    }

    public boolean isOptions() {
        return this.getMethod() == ExchangeKeys.METHOD.OPTIONS;
    }

    public boolean isPatch() {
        return this.getMethod() == ExchangeKeys.METHOD.PATCH;
    }

    public boolean isPost() {
        return this.getMethod() == ExchangeKeys.METHOD.POST;
    }

    public boolean isPut() {
        return this.getMethod() == ExchangeKeys.METHOD.PUT;
    }

    private static ExchangeKeys.METHOD selectMethod(HttpString _method) {
        if (Methods.GET.equals(_method)) {
            return ExchangeKeys.METHOD.GET;
        }
        if (Methods.POST.equals(_method)) {
            return ExchangeKeys.METHOD.POST;
        }
        if (Methods.PUT.equals(_method)) {
            return ExchangeKeys.METHOD.PUT;
        }
        if (Methods.DELETE.equals(_method)) {
            return ExchangeKeys.METHOD.DELETE;
        }
        if (PATCH.equals(_method.toString())) {
            return ExchangeKeys.METHOD.PATCH;
        }
        if (Methods.OPTIONS.equals(_method)) {
            return ExchangeKeys.METHOD.OPTIONS;
        }
        return ExchangeKeys.METHOD.OTHER;
    }

    public void blockForTooManyRequests() {
        this.getWrappedExchange().putAttachment(BLOCK_AUTH_FOR_TOO_MANY_REQUESTS, (Object)true);
    }

    public boolean isBlockForTooManyRequests() {
        Boolean block = (Boolean)this.getWrappedExchange().getAttachment(BLOCK_AUTH_FOR_TOO_MANY_REQUESTS);
        return block == null ? false : block;
    }
}

