/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.exchange;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.util.Map;
import org.restheart.exchange.ByteArrayProxyResponse;
import org.restheart.exchange.Exchange;
import org.restheart.exchange.PipelineInfo;
import org.restheart.exchange.Request;
import org.restheart.exchange.ServiceResponse;

public abstract class Response<T>
extends Exchange<T> {
    private static final AttachmentKey<Integer> STATUS_CODE = AttachmentKey.create(Integer.class);
    private static final AttachmentKey<Map<String, String>> MDC_CONTEXT_KEY = AttachmentKey.create(Map.class);

    protected Response(HttpServerExchange exchange) {
        super(exchange);
    }

    public static Response of(HttpServerExchange exchange) {
        PipelineInfo pi = Request.pipelineInfo(exchange);
        if (pi.getType() == PipelineInfo.PIPELINE_TYPE.SERVICE) {
            return ServiceResponse.of(exchange);
        }
        return ByteArrayProxyResponse.of(exchange);
    }

    public static String getContentType(HttpServerExchange exchange) {
        return exchange.getResponseHeaders().getFirst(Headers.CONTENT_TYPE);
    }

    @Override
    public String getContentType() {
        if (this.getHeaders().get(Headers.CONTENT_TYPE) != null) {
            return this.getHeaders().get(Headers.CONTENT_TYPE).getFirst();
        }
        return null;
    }

    public void setContentType(String responseContentType) {
        this.setHeader(Headers.CONTENT_TYPE, responseContentType);
    }

    public void setContentTypeAsJson() {
        this.setContentType("application/json");
    }

    public int getStatusCode() {
        HttpServerExchange wrappedExchange = this.getWrappedExchange();
        if (wrappedExchange == null || wrappedExchange.getAttachment(STATUS_CODE) == null) {
            return -1;
        }
        return (Integer)wrappedExchange.getAttachment(STATUS_CODE);
    }

    public void setStatusCode(int responseStatusCode) {
        this.getWrappedExchange().putAttachment(STATUS_CODE, (Object)responseStatusCode);
    }

    public HeaderMap getHeaders() {
        return this.wrapped.getResponseHeaders();
    }

    public String getHeader(HttpString name) {
        return this.getHeaders().getFirst(name);
    }

    public String getHeader(String name) {
        return this.getHeaders().getFirst(HttpString.tryFromString((String)name));
    }

    public void setHeader(HttpString name, String value) {
        if (this.getHeaders().get(name) == null) {
            this.getHeaders().put(name, value);
        } else {
            this.getHeaders().get(name).clear();
            this.getHeaders().get(name).add(value);
        }
    }

    public void setHeader(String name, String value) {
        if (this.getHeaders().get(name) == null) {
            this.getHeaders().put(HttpString.tryFromString((String)name), value);
        } else {
            this.getHeaders().get(HttpString.tryFromString((String)name)).clear();
            this.getHeaders().get(HttpString.tryFromString((String)name)).add(value);
        }
    }

    public Map<String, String> getMDCContext() {
        return (Map)this.getWrappedExchange().getAttachment(MDC_CONTEXT_KEY);
    }

    public void setMDCContext(Map<String, String> mdcCtx) {
        this.getWrappedExchange().putAttachment(MDC_CONTEXT_KEY, mdcCtx);
    }

    public abstract void setInError(int var1, String var2, Throwable var3);

    public void setInError(int code, String message) {
        this.setInError(code, message, null);
    }
}

