/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.exchange;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import org.restheart.exchange.Request;

public abstract class ServiceRequest<T>
extends Request<T> {
    private static final AttachmentKey<ServiceRequest<?>> REQUEST_KEY = AttachmentKey.create(ServiceRequest.class);
    protected T content;

    protected ServiceRequest(HttpServerExchange exchange) {
        this(exchange, false);
    }

    ServiceRequest(HttpServerExchange exchange, boolean dontAttach) {
        super(exchange);
        if (!dontAttach) {
            if (exchange.getAttachment(REQUEST_KEY) != null) {
                throw new IllegalStateException("Error instantiating request object " + this.getClass().getSimpleName() + ", " + ((ServiceRequest)exchange.getAttachment(REQUEST_KEY)).getClass().getSimpleName() + " already bound to the exchange");
            }
            exchange.putAttachment(REQUEST_KEY, (Object)this);
        }
    }

    public static ServiceRequest<?> of(HttpServerExchange exchange) {
        ServiceRequest ret = (ServiceRequest)exchange.getAttachment(REQUEST_KEY);
        if (ret == null) {
            throw new IllegalStateException("Request not initialized");
        }
        return ret;
    }

    public static <R extends ServiceRequest<?>> R of(HttpServerExchange exchange, Class<R> type) {
        ServiceRequest ret = (ServiceRequest)exchange.getAttachment(REQUEST_KEY);
        if (ret == null) {
            throw new IllegalStateException("Request not initialized");
        }
        if (type.isAssignableFrom(ret.getClass())) {
            return (R)ret;
        }
        throw new IllegalStateException("Request bound to exchange is not of the specified type, expected " + type.getSimpleName() + " got " + ret.getClass().getSimpleName());
    }

    public T getContent() {
        return this.content;
    }

    public void setContent(T content) {
        this.content = content;
    }

    public boolean isHandledBy(String serviceName) {
        return serviceName == null ? false : serviceName.equals(this.getPipelineInfo().getName());
    }
}

