/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.exchange;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import org.restheart.exchange.Response;

public abstract class ServiceResponse<T>
extends Response<T> {
    private static final AttachmentKey<ServiceResponse<?>> RESPONSE_KEY = AttachmentKey.create(ServiceResponse.class);
    protected T content;
    private Runnable customSender = null;

    protected ServiceResponse(HttpServerExchange exchange) {
        this(exchange, false);
    }

    protected ServiceResponse(HttpServerExchange exchange, boolean dontAttach) {
        super(exchange);
        if (!dontAttach) {
            if (exchange.getAttachment(RESPONSE_KEY) != null) {
                throw new IllegalStateException("Error instantiating response object " + this.getClass().getSimpleName() + ", " + ((ServiceResponse)exchange.getAttachment(RESPONSE_KEY)).getClass().getSimpleName() + " already bound to the exchange");
            }
            exchange.putAttachment(RESPONSE_KEY, (Object)this);
        }
    }

    public static ServiceResponse<?> of(HttpServerExchange exchange) {
        ServiceResponse ret = (ServiceResponse)exchange.getAttachment(RESPONSE_KEY);
        if (ret == null) {
            throw new IllegalStateException("Response not initialized");
        }
        return ret;
    }

    public static <R extends ServiceResponse<?>> R of(HttpServerExchange exchange, Class<R> type) {
        ServiceResponse ret = (ServiceResponse)exchange.getAttachment(RESPONSE_KEY);
        if (ret == null) {
            throw new IllegalStateException("Response not initialized");
        }
        if (type.isAssignableFrom(ret.getClass())) {
            return (R)ret;
        }
        throw new IllegalStateException("Response bound to exchange is not of the specified type, expected " + type.getSimpleName() + " got " + ret.getClass().getSimpleName());
    }

    public T getContent() {
        return this.content;
    }

    public void setContent(T content) {
        this.content = content;
    }

    public abstract String readContent();

    public void setCustomSender(Runnable customSender) {
        this.customSender = customSender;
    }

    public Runnable getCustomerSender() {
        return this.customSender;
    }

    @Override
    public abstract void setInError(int var1, String var2, Throwable var3);
}

