/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.exchange;

import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import org.restheart.exchange.ServiceRequest;
import org.restheart.utils.ChannelReader;

public class StringRequest
extends ServiceRequest<String> {
    private StringRequest(HttpServerExchange exchange) {
        super(exchange);
    }

    public static StringRequest init(HttpServerExchange exchange) {
        StringRequest ret = new StringRequest(exchange);
        try {
            ret.injectContent();
        }
        catch (IOException ieo) {
            ret.setInError(true);
        }
        return ret;
    }

    public static StringRequest of(HttpServerExchange exchange) {
        return StringRequest.of(exchange, StringRequest.class);
    }

    public void injectContent() throws IOException {
        if (this.wrapped.getRequestContentLength() > 0L) {
            this.setContent(ChannelReader.readString(this.wrapped));
        } else {
            this.setContent(null);
        }
    }
}

