/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.exchange;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import java.io.IOException;
import java.util.function.Consumer;
import org.restheart.exchange.ByteArrayProxyRequest;
import org.restheart.exchange.ServiceRequest;
import org.restheart.utils.ChannelReader;

public class UninitializedRequest
extends ServiceRequest<Object> {
    static final AttachmentKey<Consumer<HttpServerExchange>> CUSTOM_REQUEST_INITIALIZER_KEY = AttachmentKey.create(Consumer.class);

    private UninitializedRequest(HttpServerExchange exchange) {
        super(exchange, true);
    }

    public static UninitializedRequest of(HttpServerExchange exchange) {
        return new UninitializedRequest(exchange);
    }

    @Override
    public Object getContent() {
        throw new IllegalStateException("the request is not initialized");
    }

    @Override
    public void setContent(Object content) {
        throw new IllegalStateException("the request is not initialized");
    }

    public byte[] getRawContent() {
        try {
            return ChannelReader.readBytes(this.wrapped);
        }
        catch (IOException e) {
            throw new IllegalStateException("error getting raw request content", e);
        }
    }

    public void setRawContent(byte[] data) throws IOException {
        ByteArrayProxyRequest.of(this.wrapped).writeContent(data);
    }

    public void setCustomRequestInitializer(Consumer<HttpServerExchange> customRequestInitializer) {
        this.wrapped.putAttachment(CUSTOM_REQUEST_INITIALIZER_KEY, customRequestInitializer);
    }

    public Consumer<HttpServerExchange> customRequestInitializer() {
        return (Consumer)this.wrapped.getAttachment(CUSTOM_REQUEST_INITIALIZER_KEY);
    }
}

