/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.Arrays;
import java.util.Objects;

public abstract class PipelinedHandler
implements HttpHandler {
    protected static final String CONTENT_TYPE = "contentType";
    private PipelinedHandler next;

    public PipelinedHandler() {
        this(null);
    }

    public PipelinedHandler(PipelinedHandler next) {
        this.next = next;
    }

    public abstract void handleRequest(HttpServerExchange var1) throws Exception;

    protected PipelinedHandler getNext() {
        return this.next;
    }

    protected void setNext(PipelinedHandler next) {
        this.next = next;
    }

    protected void next(HttpServerExchange exchange) throws Exception {
        if (this.next != null) {
            this.next.handleRequest(exchange);
        }
    }

    public static PipelinedHandler pipe(PipelinedHandler ... handlers) {
        if (Objects.isNull(handlers)) {
            return null;
        }
        handlers = (PipelinedHandler[])Arrays.stream(handlers).filter(s -> s != null).toArray(PipelinedHandler[]::new);
        for (int idx = 0; idx < handlers.length - 1; ++idx) {
            handlers[idx].setNext(handlers[idx + 1]);
        }
        return handlers[0];
    }
}

