/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import org.restheart.exchange.ServiceRequest;
import org.restheart.exchange.ServiceResponse;
import org.restheart.handlers.PipelinedHandler;
import org.restheart.handlers.ServiceWrapper;
import org.restheart.plugins.Service;

public class PipelinedWrappingHandler
extends PipelinedHandler {
    private final HttpHandler wrapped;

    private PipelinedWrappingHandler(PipelinedHandler next, HttpHandler handler) {
        super(next);
        this.wrapped = handler;
    }

    private <R extends ServiceRequest<?>, S extends ServiceResponse<?>> PipelinedWrappingHandler(PipelinedHandler next, Service<R, S> service) {
        super(next);
        this.wrapped = new ServiceWrapper<R, S>(service);
    }

    private PipelinedWrappingHandler(HttpHandler handler) {
        super(null);
        this.wrapped = handler;
    }

    public static PipelinedWrappingHandler wrap(HttpHandler handler) {
        return PipelinedWrappingHandler.wrap(null, handler);
    }

    public static <R extends ServiceRequest<?>, S extends ServiceResponse<?>> PipelinedWrappingHandler wrap(Service<R, S> service) {
        return PipelinedWrappingHandler.wrap(null, service);
    }

    public static PipelinedWrappingHandler wrap(PipelinedHandler next, HttpHandler handler) {
        return new PipelinedWrappingHandler(next, handler);
    }

    public static <R extends ServiceRequest<?>, S extends ServiceResponse<?>> PipelinedWrappingHandler wrap(PipelinedHandler next, Service<R, S> service) {
        return new PipelinedWrappingHandler(next, service);
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (this.wrapped == null) {
            this.next(exchange);
        } else {
            this.wrapped.handleRequest(exchange);
            if (!exchange.isResponseComplete()) {
                this.next(exchange);
            }
        }
    }
}

