/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.handlers;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.QueryParameterUtils;
import java.net.URLEncoder;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.TreeMap;
import org.restheart.handlers.PipelinedHandler;

public class QueryStringRebuilder
extends PipelinedHandler {
    static final AttachmentKey<String> ORIGINAL_QUERY_STRING = AttachmentKey.create(String.class);

    public QueryStringRebuilder(PipelinedHandler next) {
        super(next);
    }

    public QueryStringRebuilder() {
        super(null);
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        this.setOriginalQueryString(exchange);
        Map qps = exchange.getQueryParameters();
        TreeMap decodedQueryParameters = new TreeMap();
        String encoding = QueryParameterUtils.getQueryParamEncoding((HttpServerExchange)exchange);
        for (String k : qps.keySet()) {
            Deque values = (Deque)qps.get(k);
            ArrayDeque<String> nvalues = new ArrayDeque<String>(values.size());
            for (String value : values) {
                nvalues.add(URLEncoder.encode(value, encoding));
            }
            decodedQueryParameters.put(k, nvalues);
        }
        String newqs = QueryParameterUtils.buildQueryString(decodedQueryParameters);
        exchange.setQueryString(newqs);
        this.next(exchange);
    }

    private void setOriginalQueryString(HttpServerExchange exchange) {
        if (exchange.getAttachment(ORIGINAL_QUERY_STRING) == null) {
            exchange.putAttachment(ORIGINAL_QUERY_STRING, (Object)exchange.getQueryString());
        }
    }

    public static String getOriginalQueryString(HttpServerExchange exchange) {
        String oqs = (String)exchange.getAttachment(ORIGINAL_QUERY_STRING);
        return oqs == null ? exchange.getQueryString() : oqs;
    }
}

