/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.metrics;

import java.util.ArrayList;
import java.util.List;

public record MetricLabel(String name, String value) {
    public static String SEPARATOR = "=";

    public MetricLabel(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.name = name.replaceAll("=", "_").replaceAll("\\.", "_");
        this.value = value.replaceAll("\\.", "_");
    }

    @Override
    public String toString() {
        return this.name.concat(SEPARATOR).concat(this.value);
    }

    public static MetricLabel from(String raw) {
        int sepIdx = raw.indexOf(SEPARATOR);
        return new MetricLabel(raw.substring(0, sepIdx), raw.substring(sepIdx + 1));
    }

    public static List<MetricLabel> collect(MetricLabel ... labels) {
        ArrayList<MetricLabel> ret = new ArrayList<MetricLabel>();
        for (MetricLabel label : labels) {
            ret.add(label);
        }
        return ret;
    }
}

