/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.metrics;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.restheart.metrics.MetricLabel;

public record MetricNameAndLabels(String name, List<MetricLabel> labels) {
    public static String SEPARATOR = ".";
    private static String SEPARATOR_REGEX = "\\.";

    public MetricNameAndLabels(String name, List<MetricLabel> labels) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (labels == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.name = name.replaceAll("SEPARATOR_REGEX", "_");
        this.labels = labels;
    }

    public static MetricNameAndLabels from(String raw) {
        String name = raw.substring(0, raw.indexOf("."));
        List<MetricLabel> labels = Arrays.stream(raw.split(SEPARATOR_REGEX)).skip(1L).map(l -> MetricLabel.from(l)).collect(Collectors.toList());
        return new MetricNameAndLabels(name, labels);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append(SEPARATOR);
        sb.append(this.labels.stream().map(l -> l.toString()).collect(Collectors.joining(SEPARATOR)));
        return sb.toString();
    }
}

