/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.metrics;

import com.codahale.metrics.MetricRegistry;
import io.undertow.attribute.ExchangeAttributes;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HttpString;
import java.util.ArrayList;
import java.util.List;
import org.restheart.exchange.Request;
import org.restheart.metrics.MetricLabel;
import org.restheart.plugins.security.Authenticator;

public class Metrics {
    private static final HttpString _X_FORWARDED_FOR = HttpString.tryFromString((String)"X-Forwarded-For");
    private static FAILED_AUTH_KEY collectFailedAuthBy = FAILED_AUTH_KEY.REMOTE_IP;
    private static int xffReverseIndex = 0;
    private static AttachmentKey<List<MetricLabel>> CUSTOM_METRIC_LABELS = AttachmentKey.create(List.class);

    public static String failedAuthHistogramName(HttpServerExchange exchange) {
        return switch (collectFailedAuthBy) {
            default -> throw new IncompatibleClassChangeError();
            case FAILED_AUTH_KEY.REMOTE_IP -> MetricRegistry.name(Authenticator.class, (String[])new String[]{"failed-auth-remote-ip", ExchangeAttributes.remoteIp().readAttribute(exchange)});
            case FAILED_AUTH_KEY.X_FORWARDED_FOR -> {
                String xff = ExchangeAttributes.requestHeader((HttpString)_X_FORWARDED_FOR).readAttribute(exchange);
                if (xff == null) {
                    yield MetricRegistry.name(Authenticator.class, (String[])new String[]{"failed-auth-x-forwarded-for", "not-set"});
                }
                yield MetricRegistry.name(Authenticator.class, (String[])new String[]{"failed-auth-x-forwarded-for", Metrics.xffValue(xff, xffReverseIndex)});
            }
        };
    }

    public static String xffValue(String xff, int rindex) {
        String[] elements;
        if (xff == null) {
            return null;
        }
        if ((xff = xff.strip()).startsWith("[")) {
            xff = xff.substring(1);
        }
        if (xff.endsWith("]")) {
            xff = xff.substring(0, xff.length() - 1);
        }
        if ((elements = xff.split(",")).length >= rindex) {
            if (rindex >= elements.length) {
                return elements[0].strip();
            }
            return elements[elements.length - 1 - rindex].strip();
        }
        return elements[elements.length - 1].strip();
    }

    public static void collectFailedAuthBy(FAILED_AUTH_KEY key) {
        collectFailedAuthBy = key;
    }

    public static void xffValueRIndex(int ridx) {
        xffReverseIndex = ridx;
    }

    public static void attachMetricLabels(Request<?> request, List<MetricLabel> labels) {
        request.getExchange().putAttachment(CUSTOM_METRIC_LABELS, labels);
    }

    public static void attachMetricLabel(Request<?> request, MetricLabel label) {
        ArrayList<MetricLabel> labels = new ArrayList<MetricLabel>();
        labels.add(label);
        request.getExchange().putAttachment(CUSTOM_METRIC_LABELS, labels);
    }

    public static List<MetricLabel> getMetricLabels(Request<?> request) {
        return (List)request.getExchange().getAttachment(CUSTOM_METRIC_LABELS);
    }

    public static enum FAILED_AUTH_KEY {
        REMOTE_IP,
        X_FORWARDED_FOR;

    }
}

