/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.mongodb;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoTimeoutException;
import com.mongodb.client.MongoClient;
import org.bson.conversions.Bson;
import org.restheart.cache.Cache;
import org.restheart.cache.CacheFactory;
import org.restheart.cache.LoadingCache;
import org.restheart.utils.BsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionChecker.class);
    private static LoadingCache<MongoClient, Boolean> CACHE = CacheFactory.createLocalLoadingCache(10L, Cache.EXPIRE_POLICY.AFTER_WRITE, 5000L, mclient -> {
        if (mclient == null) {
            return false;
        }
        try {
            mclient.getDatabase("admin").runCommand((Bson)BsonUtils.document().put("ping", 1).get());
            return true;
        }
        catch (Throwable t) {
            LOGGER.error("Error checking connection with to MongoDb", t);
            return false;
        }
    });

    public static boolean connected(MongoClient mclient) {
        return CACHE.getLoading(mclient).orElse(false);
    }

    public static boolean replicaSet(MongoClient mclient) {
        if (!ConnectionChecker.connected(mclient)) {
            throw new MongoTimeoutException("not connected");
        }
        try {
            mclient.getDatabase("admin").runCommand((Bson)BsonUtils.document().put("replSetGetStatus", 1).get());
            return true;
        }
        catch (MongoCommandException mce) {
            if (mce.getCode() == 13) {
                LOGGER.warn("Unable to check if MongoDB is configured as replica set. The MongoDB user cannot execute replSetGetStatus() command. Tip: add to the MongoDB user the built-in role 'clusterMonitor' that provides this action.");
            }
        }
        finally {
            return false;
        }
    }
}

