/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.ReadConcern;
import com.mongodb.ReadConcernLevel;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoDatabase;

public record RSOps(ReadPreference readPreference, ReadConcern readConcern, WriteConcern writeConcern) {
    public RSOps() {
        this(null, null, null);
    }

    public RSOps withReadPreference(ReadPreference readPreference) {
        return new RSOps(readPreference, this.readConcern, this.writeConcern);
    }

    public RSOps withReadPreference(String readPreference) throws IllegalArgumentException {
        return this.withReadPreference(ReadPreference.valueOf((String)readPreference));
    }

    public RSOps withReadConcern(ReadConcern readConcern) {
        return new RSOps(this.readPreference, readConcern, this.writeConcern);
    }

    public RSOps withReadConcern(String readConcern) throws IllegalArgumentException {
        return this.withReadConcern(new ReadConcern(ReadConcernLevel.fromString((String)readConcern)));
    }

    public RSOps withWriteConcern(WriteConcern writeConcern) {
        return new RSOps(this.readPreference, this.readConcern, writeConcern);
    }

    public RSOps withWriteConcern(String writeConcern) {
        return this.withWriteConcern(WriteConcern.valueOf((String)writeConcern));
    }

    public MongoDatabase apply(MongoDatabase db) {
        return this.applyWriteConcern(this.applyReadPreference(this.applyReadConcern(db)));
    }

    public MongoDatabase applyReadPreference(MongoDatabase db) {
        return this.readPreference == null ? db : db.withReadPreference(this.readPreference);
    }

    public MongoDatabase applyReadConcern(MongoDatabase db) {
        return this.readConcern == null ? db : db.withReadConcern(this.readConcern);
    }

    public MongoDatabase applyWriteConcern(MongoDatabase db) {
        return this.writeConcern == null ? db : db.withWriteConcern(this.writeConcern);
    }

    public static RSOps from(ConnectionString mongoUri) {
        return new RSOps(mongoUri.getReadPreference(), mongoUri.getReadConcern(), mongoUri.getWriteConcern());
    }
}

