/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.mongodb.db;

import org.bson.BsonDocument;
import org.bson.BsonValue;

public class OperationResult {
    private final int httpCode;
    private final Object etag;
    private final BsonDocument newData;
    private final BsonDocument oldData;
    private final BsonValue newId;
    private final Throwable cause;

    public OperationResult(int httpCode) {
        this.httpCode = httpCode;
        this.etag = null;
        this.newData = null;
        this.oldData = null;
        this.newId = null;
        this.cause = null;
    }

    public OperationResult(int httpCode, BsonDocument oldData, BsonDocument newData) {
        this.httpCode = httpCode;
        this.etag = null;
        this.newData = newData;
        this.oldData = oldData;
        this.newId = newData == null ? null : newData.get((Object)"_id");
        this.cause = null;
    }

    public OperationResult(int httpCode, Object etag) {
        this.httpCode = httpCode;
        this.etag = etag;
        this.newData = null;
        this.oldData = null;
        this.newId = null;
        this.cause = null;
    }

    public OperationResult(int httpCode, Object etag, BsonValue newId) {
        this.httpCode = httpCode;
        this.etag = etag;
        this.newId = newId;
        this.newData = null;
        this.oldData = null;
        this.cause = null;
    }

    public OperationResult(int httpCode, Object etag, BsonDocument oldData, BsonDocument newData) {
        this.httpCode = httpCode;
        this.etag = etag;
        this.newData = newData;
        this.oldData = oldData;
        this.newId = newData == null ? null : newData.get((Object)"_id");
        this.cause = null;
    }

    public OperationResult(int httpCode, Object etag, BsonDocument oldData, BsonDocument newData, Throwable cause) {
        this.httpCode = httpCode;
        this.etag = etag;
        this.newData = newData;
        this.oldData = oldData;
        this.newId = newData == null ? null : newData.get((Object)"_id");
        this.cause = cause;
    }

    public OperationResult(int httpCode, BsonDocument oldData, Throwable cause) {
        this.httpCode = httpCode;
        this.etag = null;
        this.newData = null;
        this.oldData = oldData;
        this.newId = null;
        this.cause = cause;
    }

    public int getHttpCode() {
        return this.httpCode;
    }

    public Object getEtag() {
        return this.etag;
    }

    public BsonDocument getNewData() {
        return this.newData;
    }

    public BsonDocument getOldData() {
        return this.oldData;
    }

    public BsonValue getNewId() {
        return this.newId;
    }

    public Throwable getCause() {
        return this.cause;
    }
}

