/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.mongodb.db.sessions;

import com.mongodb.ClientSessionOptions;
import com.mongodb.TransactionOptions;
import com.mongodb.client.ClientSession;
import com.mongodb.client.TransactionBody;
import com.mongodb.internal.session.BaseClientSessionImpl;
import com.mongodb.internal.session.ServerSessionPool;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.UUID;

public class ClientSessionImpl
extends BaseClientSessionImpl
implements ClientSession {
    protected boolean messageSentInCurrentTransaction;
    private boolean causallyConsistent = true;

    public ClientSessionImpl(ServerSessionPool serverSessionPool, Object originator, ClientSessionOptions options) {
        super(serverSessionPool, originator, options);
    }

    public <T> T withTransaction(TransactionBody<T> tb) {
        return (T)tb.execute();
    }

    public <T> T withTransaction(TransactionBody<T> tb, TransactionOptions to) {
        return (T)tb.execute();
    }

    public boolean hasActiveTransaction() {
        return false;
    }

    public boolean isCausallyConsistent() {
        return this.causallyConsistent;
    }

    public boolean notifyMessageSent() {
        boolean firstMessageInCurrentTransaction = !this.messageSentInCurrentTransaction;
        this.messageSentInCurrentTransaction = true;
        return firstMessageInCurrentTransaction;
    }

    public TransactionOptions getTransactionOptions() {
        throw new UnsupportedOperationException();
    }

    public void startTransaction() {
        throw new UnsupportedOperationException();
    }

    public void startTransaction(TransactionOptions transactionOptions) {
        throw new UnsupportedOperationException();
    }

    public void commitTransaction() {
        throw new UnsupportedOperationException();
    }

    public void abortTransaction() {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }

    public int hashCode() {
        return Objects.hash(this.getSid());
    }

    public UUID getSid() {
        return ClientSessionImpl.getSid(this);
    }

    public void setCausallyConsistent(boolean causallyConsistent) {
        this.causallyConsistent = causallyConsistent;
    }

    public void setMessageSentInCurrentTransaction(boolean messageSentInCurrentTransaction) {
        this.messageSentInCurrentTransaction = messageSentInCurrentTransaction;
    }

    public boolean isMessageSentInCurrentTransaction() {
        return this.messageSentInCurrentTransaction;
    }

    public static UUID getSid(ClientSession cs) {
        if (cs != null && cs.getServerSession() != null && cs.getServerSession().getIdentifier() != null && cs.getServerSession().getIdentifier().isDocument() && cs.getServerSession().getIdentifier().asDocument().containsKey((Object)"id") && cs.getServerSession().getIdentifier().asDocument().get((Object)"id").isBinary()) {
            return cs.getServerSession().getIdentifier().asDocument().get((Object)"id").asBinary().asUuid();
        }
        return null;
    }

    public void notifyOperationInitiated(Object operation) {
    }

    private static Object delegate(Object o) {
        try {
            Field delegateF = o.getClass().getDeclaredField("delegate");
            delegateF.setAccessible(true);
            return delegateF.get(o);
        }
        catch (Throwable t) {
            return o;
        }
    }
}

