/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.mongodb.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.restheart.exchange.InvalidMetadataException;
import org.restheart.exchange.QueryVariableNotBoundException;
import org.restheart.mongodb.utils.VarsInterpolator;
import org.restheart.utils.BsonUtils;
import org.restheart.utils.LambdaUtils;

public class StagesInterpolator {
    public static List<BsonDocument> interpolate(VarsInterpolator.VAR_OPERATOR varOperator, STAGE_OPERATOR stageOperator, BsonArray stages, BsonDocument values) throws InvalidMetadataException, QueryVariableNotBoundException {
        BsonArray stagesWithUnescapedOperators = BsonUtils.unescapeKeys((BsonValue)stages).asArray();
        stagesWithUnescapedOperators.stream().map(s -> s.asDocument()).filter(stage -> StagesInterpolator.optional(stageOperator, stage)).forEach(optionalStage -> {
            try {
                StagesInterpolator.checkIfVar(stageOperator, optionalStage);
            }
            catch (InvalidMetadataException ime) {
                LambdaUtils.throwsSneakyException(ime);
            }
        });
        BsonArray stagesWithoutUnboudOptionalStages = stagesWithUnescapedOperators.stream().map(s -> s.asDocument()).map(stage -> StagesInterpolator._stage(stageOperator, stage, values)).filter(stage -> stage != null).collect(Collectors.toCollection(BsonArray::new));
        BsonArray resolvedStages = VarsInterpolator.interpolate(varOperator, (BsonValue)stagesWithoutUnboudOptionalStages, values).asArray();
        ArrayList<BsonDocument> ret = new ArrayList<BsonDocument>();
        resolvedStages.stream().filter(stage -> stage.isDocument()).map(stage -> stage.asDocument()).forEach(ret::add);
        return ret;
    }

    public static void shouldNotContainOperators(BsonValue values) throws SecurityException {
        if (values == null) {
            return;
        }
        if (values.isDocument()) {
            BsonDocument _obj = values.asDocument();
            _obj.forEach((key, value) -> {
                if (key.startsWith("$")) {
                    throw new SecurityException("aggregation variables cannot include operators");
                }
                if (value.isDocument() || value.isArray()) {
                    StagesInterpolator.shouldNotContainOperators(value);
                }
            });
        } else if (values.isArray()) {
            values.asArray().getValues().stream().filter(el -> el.isDocument() || el.isArray()).forEachOrdered(StagesInterpolator::shouldNotContainOperators);
        }
    }

    private static boolean optional(STAGE_OPERATOR stageOperator, BsonDocument stage) {
        return stage.containsKey((Object)stageOperator.name());
    }

    private static void checkIfVar(STAGE_OPERATOR stageOperator, BsonDocument stage) throws InvalidMetadataException {
        BsonValue ifvar;
        if (!(!stage.containsKey((Object)stageOperator.name()) || (ifvar = stage.get((Object)stageOperator.name())).isArray() && (ifvar.asArray().size() == 2 || ifvar.asArray().size() == 3) && (ifvar.asArray().get(0).isString() || ifvar.asArray().get(0).isArray() && ifvar.asArray().get(0).asArray().stream().allMatch(e -> e.isString()) || ifvar.asArray().get(1).isDocument() || ifvar.asArray().size() > 2 && ifvar.asArray().get(2).isDocument()))) {
            throw new InvalidMetadataException("Invalid optional stage: " + BsonUtils.toJson((BsonValue)stage));
        }
    }

    private static boolean stageApplies(STAGE_OPERATOR stageOperator, BsonDocument stage, BsonDocument avars) {
        BsonValue vars = stage.get((Object)stageOperator.name()).asArray().get(0);
        if (vars.isString()) {
            return BsonUtils.get(avars, vars.asString().getValue()).isPresent();
        }
        return vars.asArray().stream().map(s -> s.asString().getValue()).allMatch(key -> BsonUtils.get(avars, key).isPresent());
    }

    private static BsonDocument elseStage(STAGE_OPERATOR stageOperator, BsonDocument stage) {
        return stage.get((Object)stageOperator.name()).asArray().size() > 2 ? stage.get((Object)stageOperator.name()).asArray().get(2).asDocument() : null;
    }

    private static BsonDocument _stage(STAGE_OPERATOR stageOperator, BsonDocument stage, BsonDocument avars) {
        if (!StagesInterpolator.optional(stageOperator, stage)) {
            return stage;
        }
        if (StagesInterpolator.stageApplies(stageOperator, stage, avars)) {
            return stage.get((Object)stageOperator.name()).asArray().get(1).asDocument();
        }
        return StagesInterpolator.elseStage(stageOperator, stage);
    }

    public static enum STAGE_OPERATOR {
        $ifvar,
        $ifarg;

    }
}

