/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.mongodb.utils;

import java.util.Optional;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.restheart.exchange.InvalidMetadataException;
import org.restheart.exchange.QueryVariableNotBoundException;
import org.restheart.utils.BsonUtils;

public class VarsInterpolator {
    public static BsonValue interpolate(VAR_OPERATOR operator, BsonValue bson, BsonDocument values) throws InvalidMetadataException, QueryVariableNotBoundException {
        if (bson == null) {
            return null;
        }
        if (bson.isDocument()) {
            BsonDocument _obj = bson.asDocument();
            if (_obj.size() == 1 && _obj.get((Object)operator.name()) != null) {
                BsonValue v = _obj.get((Object)operator.name());
                if (v.isArray() && v.asArray().size() == 2) {
                    BsonValue _name = v.asArray().get(0);
                    BsonValue defaultValue = v.asArray().get(1);
                    if (!_name.isString()) {
                        throw new InvalidMetadataException("wrong variable name " + v.toString());
                    }
                    String name = _name.asString().getValue();
                    if (values == null) {
                        return defaultValue;
                    }
                    Optional<BsonValue> value = BsonUtils.get(values, name);
                    return value.isPresent() ? value.get() : defaultValue;
                }
                if (v.isString()) {
                    if (values == null || BsonUtils.get(values, v.asString().getValue()).isEmpty()) {
                        throw new QueryVariableNotBoundException("variable " + v.asString().getValue() + " not bound");
                    }
                    Optional<BsonValue> value = BsonUtils.get(values, v.asString().getValue());
                    return value.isPresent() ? value.get() : null;
                }
                throw new InvalidMetadataException("wrong variable name " + v.toString());
            }
            BsonDocument ret = new BsonDocument();
            for (String key : _obj.keySet()) {
                ret.put(key, VarsInterpolator.interpolate(operator, _obj.get((Object)key), values));
            }
            return ret;
        }
        if (bson.isArray()) {
            BsonArray ret = new BsonArray();
            for (BsonValue el : bson.asArray().getValues()) {
                if (el.isDocument()) {
                    ret.add(VarsInterpolator.interpolate(operator, el, values));
                    continue;
                }
                if (el.isArray()) {
                    ret.add(VarsInterpolator.interpolate(operator, el, values));
                    continue;
                }
                ret.add(el);
            }
            return ret;
        }
        return bson;
    }

    public static enum VAR_OPERATOR {
        $var,
        $arg;

    }
}

