/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.restheart.configuration.Configuration;
import org.restheart.configuration.ConfigurationException;
import org.restheart.plugins.ConfigurablePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public abstract class FileConfigurablePlugin
implements ConfigurablePlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileConfigurablePlugin.class);

    public abstract Consumer<? super Map<String, Object>> consumeConfiguration() throws ConfigurationException;

    public void init(Map<String, Object> arguments, String type) throws FileNotFoundException, ConfigurationException {
        InputStream is = null;
        try {
            String confFilePath = this.extractConfigFilePath(arguments);
            is = new FileInputStream(new File(URLDecoder.decode(confFilePath, "utf-8")));
            Map conf = (Map)new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions())).load(is);
            List<Map<String, Object>> confItems = this.extractConfArgs(conf, type);
            confItems.stream().forEach(this.consumeConfiguration());
        }
        catch (FileNotFoundException ex) {
            LOGGER.error("*** cannot find the file {} specified in the configuration.", (Object)this.extractConfigFilePath(arguments));
            LOGGER.error("*** note that the path must be either absolute or relative to the restheart configuration file (if specified) or relative to the plugins directory (if using the default configuration)");
            throw ex;
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                LOGGER.warn("Can't close the InputStream", (Throwable)ex);
            }
        }
    }

    String extractConfigFilePath(Map<String, Object> arguments) throws IllegalArgumentException {
        if (arguments == null) {
            throw new IllegalArgumentException("missing required arguments conf-file");
        }
        Object _confFilePath = arguments.getOrDefault("conf-file", null);
        if (_confFilePath == null || !(_confFilePath instanceof String)) {
            throw new IllegalArgumentException("missing required arguments conf-file");
        }
        Path restheartConfFilePath = Configuration.getPath();
        Object confFilePath = _confFilePath;
        if (!((String)confFilePath).startsWith("/")) {
            if (restheartConfFilePath != null) {
                confFilePath = restheartConfFilePath.toAbsolutePath().getParent().resolve((String)confFilePath).toString();
            } else {
                URL location = this.getClass().getProtectionDomain().getCodeSource().getLocation();
                File locationFile = new File(location.getPath());
                confFilePath = locationFile.getParent() + File.separator + (String)confFilePath;
            }
        }
        return confFilePath;
    }

    List<Map<String, Object>> extractConfArgs(Map<String, Object> conf, String type) throws IllegalArgumentException {
        Object args = conf.get(type);
        if (args == null || !(args instanceof List)) {
            throw new IllegalArgumentException("wrong configuration file format. missing mandatory '" + type + "' section.");
        }
        List users = (List)args;
        return users;
    }
}

