/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.plugins;

import java.util.Map;
import org.restheart.plugins.Plugin;

public class PluginRecord<T extends Plugin> {
    private final String name;
    private final String description;
    private final boolean secure;
    private final boolean enabledByDefault;
    private final String className;
    private final T instance;
    private final Map<String, Object> confArgs;
    public static final String PLUGIN_ENABLED_KEY = "enabled";
    public static final String PLUGIN_SECURE_KEY = "secured";

    public PluginRecord(String name, String description, boolean secure, boolean enabledByDefault, String className, T instance, Map<String, Object> confArgs) {
        this.name = name;
        this.description = description;
        this.secure = secure;
        this.enabledByDefault = enabledByDefault;
        this.instance = instance;
        this.className = className;
        this.confArgs = confArgs;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isSecure() {
        return PluginRecord.isSecure(this.secure, this.getConfArgs());
    }

    public boolean isEnabled() {
        return PluginRecord.isEnabled(this.enabledByDefault, this.getConfArgs());
    }

    public static boolean isEnabled(boolean enabledByDefault, Map<String, Object> confArgs) {
        return confArgs == null ? enabledByDefault : (confArgs.containsKey(PLUGIN_ENABLED_KEY) && confArgs.get(PLUGIN_ENABLED_KEY) != null && confArgs.get(PLUGIN_ENABLED_KEY) instanceof Boolean ? (Boolean)confArgs.get(PLUGIN_ENABLED_KEY) : enabledByDefault);
    }

    public static boolean isSecure(boolean secure, Map<String, Object> confArgs) {
        return confArgs == null ? secure : (confArgs.containsKey(PLUGIN_SECURE_KEY) && confArgs.get(PLUGIN_SECURE_KEY) != null && confArgs.get(PLUGIN_SECURE_KEY) instanceof Boolean ? (Boolean)confArgs.get(PLUGIN_SECURE_KEY) : secure);
    }

    public Map<String, Object> getConfArgs() {
        return this.confArgs;
    }

    public T getInstance() {
        return this.instance;
    }
}

