/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.plugins;

import io.undertow.server.HttpServerExchange;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.restheart.exchange.CORSHeaders;
import org.restheart.exchange.Exchange;
import org.restheart.exchange.Request;
import org.restheart.exchange.Response;
import org.restheart.exchange.ServiceRequest;
import org.restheart.exchange.ServiceResponse;
import org.restheart.plugins.ConfigurablePlugin;
import org.restheart.plugins.HandlingPlugin;

public interface Service<R extends ServiceRequest<?>, S extends ServiceResponse<?>>
extends HandlingPlugin<R, S>,
ConfigurablePlugin,
CORSHeaders {
    default public void handle(R request, S response) throws Exception {
        this.handle().accept(request, response);
    }

    default public BiConsumer<R, S> handle() throws Exception {
        return (r, s) -> {
            throw new UnsupportedOperationException("handle function not implemented");
        };
    }

    public Consumer<HttpServerExchange> requestInitializer();

    public Consumer<HttpServerExchange> responseInitializer();

    public Function<HttpServerExchange, R> request();

    public Function<HttpServerExchange, S> response();

    default public void handleOptions(R request) {
        HttpServerExchange exchange = ((Exchange)request).getExchange();
        Response response = Response.of(exchange);
        response.getHeaders().put(ACCESS_CONTROL_ALLOW_METHODS, this.accessControlAllowMethods((Request<?>)request)).put(ACCESS_CONTROL_ALLOW_HEADERS, this.accessControlAllowHeaders((Request<?>)request));
        response.setStatusCode(200);
        exchange.endExchange();
    }

    default public BiConsumer<R, S> handleOptions() {
        return (r, s) -> this.handleOptions(r);
    }
}

