/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security;

import com.google.gson.JsonElement;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import io.undertow.attribute.ExchangeAttributes;
import io.undertow.predicate.PredicateParser;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import java.math.BigInteger;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonNull;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.restheart.configuration.ConfigurationException;
import org.restheart.exchange.MongoRequest;
import org.restheart.exchange.Request;
import org.restheart.security.FileRealmAccount;
import org.restheart.security.JwtAccount;
import org.restheart.security.MongoPermissions;
import org.restheart.security.MongoRealmAccount;
import org.restheart.security.WithProperties;
import org.restheart.utils.BsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclVarsInterpolator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AclVarsInterpolator.class);
    private static String RUV_REGEX = "\\\\\"|\"(?:\\\\\"|[^\"])*\"|\\\\'|'(?:\\\\'|[^'])*'|(@placeholder[^)|^,]*)";
    private static final Random RND_GENERATOR = new Random();

    public static BsonValue interpolateBson(MongoRequest request, BsonValue bson) {
        if (bson.isDocument()) {
            BsonDocument ret = new BsonDocument();
            BsonDocument doc = bson.asDocument();
            doc.keySet().stream().forEach(k -> {
                BsonValue value = doc.get(k);
                if (value.isString()) {
                    ret.put(k, AclVarsInterpolator.interpolatePropValue(request, k, doc.get(k).asString().getValue()));
                } else if (value.isDocument()) {
                    ret.put(k, AclVarsInterpolator.interpolateBson(request, value));
                } else if (value.isArray()) {
                    BsonArray array = new BsonArray();
                    value.asArray().stream().forEachOrdered(e -> array.add(AclVarsInterpolator.interpolateBson(request, e)));
                    ret.put(k, (BsonValue)array);
                } else {
                    ret.put(k, value);
                }
            });
            return ret;
        }
        if (bson.isArray()) {
            BsonArray ret = new BsonArray();
            bson.asArray().stream().forEachOrdered(ae -> ret.add(AclVarsInterpolator.interpolateBson(request, ae)));
            return ret;
        }
        if (bson.isString()) {
            return AclVarsInterpolator.interpolatePropValue(request, null, bson.asString().getValue());
        }
        return bson;
    }

    public static BsonValue interpolatePropValue(MongoRequest request, String key, String value) {
        if (value == null) {
            return BsonNull.VALUE;
        }
        if ("%USER".equals(value)) {
            return new BsonString(ExchangeAttributes.remoteUser().readAttribute(request.getExchange()));
        }
        if ("%ROLES".equals(value)) {
            if (Objects.nonNull(request.getAuthenticatedAccount()) && Objects.nonNull(request.getAuthenticatedAccount().getRoles())) {
                BsonArray ret = new BsonArray();
                request.getAuthenticatedAccount().getRoles().stream().map(s -> new BsonString(s)).forEachOrdered(arg_0 -> ((BsonArray)ret).add(arg_0));
                return ret;
            }
            return new BsonArray();
        }
        if ("%NOW".equals(value) || "@now".equals(value)) {
            return new BsonDateTime(Instant.now().getEpochSecond() * 1000L);
        }
        if (value.equals("@user")) {
            Account account = request.getAuthenticatedAccount();
            if (account instanceof MongoRealmAccount) {
                MongoRealmAccount maccount = (MongoRealmAccount)account;
                return maccount.properties();
            }
            account = request.getAuthenticatedAccount();
            if (account instanceof FileRealmAccount) {
                FileRealmAccount faccount = (FileRealmAccount)account;
                return AclVarsInterpolator.toBson(faccount.properties());
            }
            account = request.getAuthenticatedAccount();
            if (account instanceof JwtAccount) {
                JwtAccount jwtAccount = (JwtAccount)account;
                Map<String, ? super Object> jwt = jwtAccount.propertiesAsMap();
                jwt.remove("exp");
                jwt.remove("iss");
                jwt.remove("sub");
                return AclVarsInterpolator.toBson(jwt);
            }
            return BsonNull.VALUE;
        }
        if (value.equals("@filter")) {
            return request.getFiltersDocument();
        }
        if (value.equals("@request")) {
            return AclVarsInterpolator.getRequestObject(request);
        }
        if (value.startsWith("@request.") && value.length() > 8) {
            BsonDocument requestObject = AclVarsInterpolator.getRequestObject(request);
            String prop = value.substring(9);
            LOGGER.debug("request doc: {}", (Object)requestObject.toJson());
            if (prop.contains(".")) {
                try {
                    Object v = JsonPath.read((String)requestObject.toJson(), (String)"$.".concat(prop), (Predicate[])new Predicate[0]);
                    return BsonUtils.parse(v.toString());
                }
                catch (Throwable pnfe) {
                    return BsonNull.VALUE;
                }
            }
            if (requestObject.containsKey((Object)prop)) {
                return requestObject.get((Object)prop);
            }
            return BsonNull.VALUE;
        }
        if (value.equals("@mongoPermissions")) {
            if (MongoPermissions.of(request) != null) {
                return MongoPermissions.of(request).asBson();
            }
            return BsonNull.VALUE;
        }
        if (value.startsWith("@mongoPermissions.") && value.length() > 17) {
            if (MongoPermissions.of(request) != null) {
                BsonDocument doc = MongoPermissions.of(request).asBson();
                String prop = value.substring(18);
                LOGGER.debug("permission doc: {}", (Object)doc);
                if (prop.contains(".")) {
                    try {
                        JsonElement v = (JsonElement)JsonPath.read((String)doc.toJson(), (String)"$.".concat(prop), (Predicate[])new Predicate[0]);
                        return BsonUtils.parse(v.toString());
                    }
                    catch (Throwable pnfe) {
                        return BsonNull.VALUE;
                    }
                }
                if (doc.containsKey((Object)prop)) {
                    return doc.get((Object)prop);
                }
                return BsonNull.VALUE;
            }
            return BsonNull.VALUE;
        }
        if (value.startsWith("@user.") && value.length() > 5) {
            Account account = request.getAuthenticatedAccount();
            if (account instanceof WithProperties) {
                WithProperties accountWithProperties = (WithProperties)account;
                return AclVarsInterpolator.fromProperties(accountWithProperties.propertiesAsMap(), value.substring(6));
            }
            return BsonNull.VALUE;
        }
        return new BsonString(value);
    }

    public static io.undertow.predicate.Predicate interpolatePredicate(Request<?> request, String predicate, ClassLoader classLoader) throws ConfigurationException {
        BsonDocument a = AclVarsInterpolator.getAccountDocument(request);
        try {
            if (a == null || a.isEmpty()) {
                return PredicateParser.parse((String)predicate, (ClassLoader)classLoader);
            }
            String interpolatedPredicate = AclVarsInterpolator.interpolatePredicate(predicate, "@user.", a);
            return PredicateParser.parse((String)interpolatedPredicate, (ClassLoader)classLoader);
        }
        catch (Throwable t) {
            throw new ConfigurationException("Wrong permission: invalid predicate " + predicate, t);
        }
    }

    private static BsonDocument getAccountDocument(Request<?> request) {
        Account account = request.getAuthenticatedAccount();
        if (account instanceof MongoRealmAccount) {
            MongoRealmAccount maccount = (MongoRealmAccount)account;
            return maccount.properties();
        }
        account = request.getAuthenticatedAccount();
        if (account instanceof FileRealmAccount) {
            FileRealmAccount faccount = (FileRealmAccount)account;
            return AclVarsInterpolator.toBson(faccount.properties()).asDocument();
        }
        account = request.getAuthenticatedAccount();
        if (account instanceof JwtAccount) {
            JwtAccount jwtAccount = (JwtAccount)account;
            return AclVarsInterpolator.toBson(jwtAccount.propertiesAsMap()).asDocument();
        }
        return null;
    }

    static String interpolatePredicate(String predicate, String prefix, BsonDocument variableValues) {
        if (variableValues == null || variableValues.isEmpty()) {
            return predicate;
        }
        BsonDocument flatten = BsonUtils.flatten(variableValues, true);
        String[] ret = new String[]{predicate};
        flatten.keySet().stream().filter(key -> flatten.get(key) != null).filter(key -> AclVarsInterpolator.isJsonPrimitive(flatten.get(key))).forEach(key -> {
            ret[0] = ret[0].replaceAll(prefix.concat((String)key), AclVarsInterpolator.quote(AclVarsInterpolator.jsonPrimitiveValue(flatten.get(key))));
        });
        flatten.keySet().stream().filter(key -> flatten.get(key) != null).filter(key -> AclVarsInterpolator.isJsonArray(flatten.get(key))).forEach(key -> {
            ret[0] = ret[0].replaceAll(prefix.concat((String)key), AclVarsInterpolator.jsonArrayValue(flatten.get(key).asArray()));
        });
        flatten.keySet().stream().forEach(key -> {
            ret[0] = AclVarsInterpolator.removeUnboundVariables(prefix, ret[0]);
        });
        return ret[0];
    }

    private static boolean isJsonPrimitive(BsonValue value) {
        return value.isNull() || value.isBoolean() || value.isNumber() || value.isString() || value.isObjectId() || value.isTimestamp() || value.isDateTime();
    }

    private static boolean isJsonArray(BsonValue value) {
        return value.isArray();
    }

    private static String jsonPrimitiveValue(BsonValue value) {
        switch (value.getBsonType()) {
            case NULL: {
                return "null";
            }
            case BOOLEAN: {
                return value.asBoolean().toString();
            }
            case INT32: {
                return "" + value.asInt32().getValue();
            }
            case INT64: {
                return "" + value.asInt64().getValue();
            }
            case DOUBLE: {
                return "" + value.asDouble().getValue();
            }
            case STRING: {
                return value.asString().getValue();
            }
            case OBJECT_ID: {
                return value.asObjectId().getValue().toHexString();
            }
            case DATE_TIME: {
                return "" + value.asDateTime().getValue();
            }
            case TIMESTAMP: {
                return "" + value.asTimestamp().getValue();
            }
        }
        throw new IllegalArgumentException("Cannot use in predicate field of type " + value.getBsonType());
    }

    private static String jsonArrayValue(BsonArray array) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append(array.stream().filter(e -> AclVarsInterpolator.isJsonPrimitive(e)).map(e -> AclVarsInterpolator.quote(AclVarsInterpolator.jsonPrimitiveValue(e))).collect(Collectors.joining(",")));
        sb.append("}");
        return sb.toString();
    }

    private static String quote(String s) {
        return "\"".concat(s).concat("\"");
    }

    private static String nextToken() {
        return new BigInteger(256, RND_GENERATOR).toString(36);
    }

    static String removeUnboundVariables(String prefix, String predicate) {
        Pattern regex = Pattern.compile(RUV_REGEX.replaceAll("@placeholder", prefix));
        Matcher m = regex.matcher(predicate);
        StringBuilder sb = new StringBuilder();
        while (m.find()) {
            if (m.group().startsWith("\"") || m.group().startsWith("'")) continue;
            m.appendReplacement(sb, AclVarsInterpolator.nextToken());
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static BsonValue fromProperties(Map<String, ? super Object> properties, String key) {
        if (key.contains(".")) {
            String first = key.substring(0, key.indexOf("."));
            String last = key.substring(key.indexOf(".") + 1);
            Object subProperties = properties.get(first);
            if (subProperties != null && subProperties instanceof Map) {
                return AclVarsInterpolator.fromProperties((Map)subProperties, last);
            }
            if (subProperties != null && subProperties instanceof List) {
                List list = (List)subProperties;
                if (last.contains(".")) {
                    String next = last.substring(0, last.indexOf("."));
                    try {
                        int idx = Integer.parseInt(next);
                        Object elementAtIdx = list.get(idx);
                        String afterNext = last.substring(last.indexOf(".") + 1);
                        if (elementAtIdx instanceof Map) {
                            return AclVarsInterpolator.fromProperties((Map)elementAtIdx, afterNext);
                        }
                        LOGGER.warn("Key {} at {} matches an array but selected element is not an object", (Object)key, (Object)first);
                        return BsonNull.VALUE;
                    }
                    catch (Throwable t) {
                        LOGGER.warn("Key {} at {} matches an array but following part is not a number", (Object)key, (Object)first);
                        return BsonNull.VALUE;
                    }
                }
                try {
                    int idx = Integer.parseInt(last);
                    return AclVarsInterpolator.toBson(list.get(idx));
                }
                catch (Throwable t) {
                    LOGGER.error("Key {} at {} matches an array but following part is not a number", (Object)key, (Object)first);
                    return BsonNull.VALUE;
                }
            }
            return BsonNull.VALUE;
        }
        if (properties.containsKey(key)) {
            return AclVarsInterpolator.toBson(properties.get(key));
        }
        return BsonNull.VALUE;
    }

    private static BsonValue toBson(Object obj) {
        if (obj == null) {
            return BsonNull.VALUE;
        }
        if (obj instanceof String) {
            String s = (String)obj;
            return new BsonString(s);
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            BsonDocument ret = new BsonDocument();
            map.entrySet().stream().filter(e -> e.getKey() instanceof String).forEachOrdered(e -> ret.put((String)e.getKey(), AclVarsInterpolator.toBson(e.getValue())));
            return ret;
        }
        if (obj instanceof List) {
            List list = (List)obj;
            BsonArray ret = new BsonArray();
            list.stream().forEachOrdered(e -> ret.add(AclVarsInterpolator.toBson(e)));
            return ret;
        }
        if (obj instanceof Integer) {
            Integer i = (Integer)obj;
            return new BsonInt32(i.intValue());
        }
        if (obj instanceof Long) {
            Long l = (Long)obj;
            return new BsonInt64(l.longValue());
        }
        if (obj instanceof Double) {
            Double d = (Double)obj;
            return new BsonDouble(d.doubleValue());
        }
        if (obj instanceof Boolean) {
            Boolean b = (Boolean)obj;
            return new BsonBoolean(b.booleanValue());
        }
        LOGGER.warn("Cannot convert value {} to BSON, the type {} is not supported", obj, (Object)obj.getClass().getSimpleName());
        return BsonNull.VALUE;
    }

    private static BsonDocument getRequestObject(MongoRequest request) {
        HttpServerExchange exchange = request.getExchange();
        BsonDocument properties = new BsonDocument();
        properties.put("db", (BsonValue)(request.getDBName() == null ? BsonNull.VALUE : new BsonString(request.getDBName())));
        properties.put("collection", (BsonValue)(request.getDBName() == null ? BsonNull.VALUE : new BsonString(request.getCollectionName())));
        properties.put("_id", (BsonValue)(request.getDocumentId() == null ? BsonNull.VALUE : request.getDocumentId()));
        properties.put("resourceType", (BsonValue)new BsonString(request.getType().name()));
        String _userName = ExchangeAttributes.remoteUser().readAttribute(exchange);
        BsonNull userName = _userName != null ? new BsonString(_userName) : BsonNull.VALUE;
        properties.put("userName", (BsonValue)userName);
        properties.put("epochTimeStamp", (BsonValue)new BsonDateTime(Instant.now().getEpochSecond() * 1000L));
        properties.put("dateTime", (BsonValue)new BsonString(ExchangeAttributes.dateTime().readAttribute(exchange)));
        properties.put("localIp", (BsonValue)new BsonString(ExchangeAttributes.localIp().readAttribute(exchange)));
        properties.put("localPort", (BsonValue)new BsonString(ExchangeAttributes.localPort().readAttribute(exchange)));
        properties.put("localServerName", (BsonValue)new BsonString(ExchangeAttributes.localServerName().readAttribute(exchange)));
        properties.put("queryString", (BsonValue)new BsonString(ExchangeAttributes.queryString().readAttribute(exchange)));
        properties.put("relativePath", (BsonValue)new BsonString(ExchangeAttributes.relativePath().readAttribute(exchange)));
        properties.put("remoteIp", (BsonValue)new BsonString(ExchangeAttributes.remoteIp().readAttribute(exchange)));
        properties.put("method", (BsonValue)new BsonString(ExchangeAttributes.requestMethod().readAttribute(exchange)));
        properties.put("protocol", (BsonValue)new BsonString(ExchangeAttributes.requestProtocol().readAttribute(exchange)));
        return properties;
    }
}

