/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security;

import com.google.common.collect.Sets;
import io.undertow.security.idm.Account;
import java.security.Principal;
import java.util.LinkedHashSet;
import java.util.Set;
import org.restheart.security.BasePrincipal;

public class BaseAccount
implements Account {
    private static final long serialVersionUID = 4199620709967413442L;
    private final Principal principal;
    private final LinkedHashSet<String> roles;

    public BaseAccount(String name, Set<String> roles) {
        if (name == null) {
            throw new IllegalArgumentException("argument principal cannot be null");
        }
        this.roles = roles == null || roles.isEmpty() ? Sets.newLinkedHashSet() : Sets.newLinkedHashSet(roles);
        this.principal = new BasePrincipal(name);
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public String toString() {
        return "username=".concat(this.principal != null ? this.principal.getName() : "null").concat(" roles=").concat(this.roles != null ? this.roles.toString() : "null");
    }
}

