/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security;

import io.undertow.util.AttachmentKey;
import java.util.Set;
import java.util.function.Predicate;
import org.restheart.exchange.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAclPermission {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseAclPermission.class);
    public static final AttachmentKey<BaseAclPermission> MATCHING_ACL_PERMISSION = AttachmentKey.create(BaseAclPermission.class);
    private Predicate<Request<?>> predicate;
    private final Set<String> roles;
    private final int priority;
    private final Object raw;

    public BaseAclPermission(Predicate<Request<?>> predicate, Set<String> roles, int priority, Object raw) {
        this.predicate = predicate;
        this.roles = roles;
        this.priority = priority;
        this.raw = raw;
    }

    public static BaseAclPermission of(Request<?> request) {
        return (BaseAclPermission)request.getExchange().getAttachment(MATCHING_ACL_PERMISSION);
    }

    public boolean allow(Request<?> request) {
        try {
            return this.predicate.test(request);
        }
        catch (Throwable t) {
            LOGGER.error("Error testing predicate {}", t);
            return false;
        }
    }

    public Predicate<Request<?>> gePredicate() {
        return this.predicate;
    }

    void setPredicate(Predicate<Request<?>> predicate) {
        this.predicate = predicate;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public int getPriority() {
        return this.priority;
    }

    public Object getRaw() {
        return this.raw;
    }

    public static Object getRaw(Request<?> request) {
        BaseAclPermission permission = BaseAclPermission.of(request);
        if (permission != null) {
            return permission.getRaw();
        }
        return null;
    }
}

