/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.restheart.exchange.Request;
import org.restheart.security.BaseAclPermission;

public class BaseAclPermissionTransformer {
    Predicate<BaseAclPermission> resolve;
    BiPredicate<BaseAclPermission, Request<?>> additionalPredicate;

    public BaseAclPermissionTransformer(Predicate<BaseAclPermission> resolve, BiPredicate<BaseAclPermission, Request<?>> additionalPredicate) {
        Objects.nonNull(resolve);
        Objects.nonNull(additionalPredicate);
        this.resolve = resolve;
        this.additionalPredicate = additionalPredicate;
    }

    public void transform(BaseAclPermission permission) {
        if (this.resolve.test(permission)) {
            permission.setPredicate(permission.gePredicate().and(BaseAclPermissionTransformer.top(this.additionalPredicate, permission)));
        }
    }

    private static Predicate<Request<?>> top(BiPredicate<BaseAclPermission, Request<?>> bp, BaseAclPermission permission) {
        return r -> bp.test(permission, (Request<?>)r);
    }
}

