/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.restheart.security.BaseAccount;
import org.restheart.security.WithProperties;

public class JwtAccount
extends BaseAccount
implements WithProperties<String> {
    private static final long serialVersionUID = -2405615782892727187L;
    private final String properties;
    private static Gson GSON = new GsonBuilder().serializeNulls().create();

    public JwtAccount(String name, Set<String> roles, String properties) {
        super(name, roles);
        this.properties = properties;
    }

    @Override
    public String toString() {
        return super.toString().concat(" jwt=").concat(this.properties);
    }

    @Override
    public String properties() {
        return this.properties;
    }

    @Override
    public Map<String, ? super Object> propertiesAsMap() {
        return (Map)GSON.fromJson(this.properties, HashMap.class);
    }
}

